#!/usr/bin/perl

# TODO
#   同じ名前の SceneGraph が来た時の処理
#   まあ Blender の時点でそうならないように書くべきなんだが

####################################
#
# Create SceneGraph List
# 
# SceneGraph が記載された xml ファイルを読み込み、
# 名前に対応するID列が記述された SGList.h を生成する。
# また、名前から ID を取得するために sglist_table を生成しておく。
# sglist_table は SGList.cpp に記述する
#
# xml に ID を入れれば table は要らないんだが、
# xml の読み込む順番、その時々に応じて使うものと使わないもので
# ID にズレが出てくるので、Blender からの出力時点では決定できない。
# このスクリプトで xml に上書きするって手もあるけど、微妙じゃない？
# 
# xml ファイルは複数指定可能。
# 実際に使うやつ全て指定する感じでおk
# 
# (例)
# 
# % cat ../xml_file/universe.xml
# 
# <?xml version="1.0"?>
# <OBJECT-3D>
#     <surface name="Earth" size="5952" prim="Triangle" parent="NULL">
#        (省略)
#     </surface>
# 
#     <surface name="Moon" size="3312" prim="Triangle" parent="Earth">
#        (省略)
#     </surface>
# <OBJECT-3D>
# 
# % ./create_sglist.pl ../xml_file/universe.xml
# % cat SGList.h
# 
# /* ../xml_file/universe.xml */
# #define Earth 0
# #define Moon 1
# 
# /* Number of Scene */
# #define SGLIST_LENGTH 2
# 
# /* Scene Table */
# const char *sglist_table[SGLIST_LENGTH] = {
#     "Earth", "Moon"
# };
# 
####################################

use strict;
#
# to install this,
# cpan -i XML::LibXML::SAX::Generator
#
use XML::LibXML;

my $file = "SGList";
my $id = 0;
my @table;

###################
# cretae SGList.h #
###################

my $done = 0;

if ($ARGV[0]=~/-o/) {
    shift;
    $_ = shift;
    s/\.(h|cc)$//;
    $file = $_;
}

open(FH, ">$file.h");

print FH "#ifndef INCLUDED_SGLIST\n";
print FH "#define INCLUDED_SGLIST\n\n";

foreach (@ARGV) {
    my $parser = XML::LibXML->new();
    my $doc = $parser->parse_file($_);
    my @nodes = $doc->findnodes('//surface');

    print FH "/* $_ */\n";

    foreach my $surface (@nodes) {
	my $name = $surface->findvalue('@name');

	$table[$id] = $name;

	print FH "#define $name\t $id\n";
	$id++;
    }

    print FH "\n";
}

print FH "/* Number of Scene */\n";
print FH "#define SGLIST_LENGTH $id\n\n";

print FH "/* Scene Table */\n";
print FH "extern const char *sglist_table[SGLIST_LENGTH+1];\n\n";
print FH "#endif\n";

close(FH);

#####################
# cretae SGList.cpp #
#####################
open(FH, ">$file.cc") or die "Error: Can't open file : $file.cc\n";

print FH "#include \"$file.h\"\n\n";
print FH "const char *sglist_table[SGLIST_LENGTH+1] = {\n";
print FH "    \"";
print FH join("\", \"", @table);
print FH "\",0\n};\n";

close(FH);
