#include "fb.h"
#include <SDL.h>
using namespace std;

void send_current_error_msg(const char *ptr)
{
    fprintf( stderr , "%s\n" , ptr );
}

void send_current_information(const char *ptr)
{
    fprintf( stdout , "%s\n" , ptr );
}

const int redMask   = 0x00ff0000;
const int greenMask = 0x0000ff00;
const int blueMask  = 0x000000ff;
const int alphaMask = 0xff000000;

fb_t
get_fbdev_addr(void)
{
  int fd_framebuffer ;
  struct fb_var_screeninfo vinfo;
  struct fb_fix_screeninfo finfo;
  long int screensize ;
  //long int location;
  char *fbptr ;
  char tmp[DIV_BYTE*10];

  //int x , y ;
  int xres,yres,vbpp,line_len;
  //unsigned short tcolor ;

  /* 読み書き用にファイルを開く */
  fd_framebuffer = open( DEVICE_NAME , O_RDWR);
  if ( !fd_framebuffer ) {
    send_current_error_msg("Framebuffer device open error !");
    exit(1);
  }
  send_current_information("The framebuffer device was opened !");
	
  /* 固定スクリーン情報取得 */
  if ( ioctl( fd_framebuffer , FBIOGET_FSCREENINFO , &finfo ) ) {
    send_current_error_msg("Fixed information not gotton !");
    exit(2);
  }

  /* 変動スクリーン情報取得 */
  if ( ioctl( fd_framebuffer , FBIOGET_VSCREENINFO , &vinfo ) ) {
    send_current_error_msg("Variable information not gotton !");
    exit(3);
  }
  xres = vinfo.xres ;
  yres = vinfo.yres ;
  printf("vinfo.yres %d \n", vinfo.yres);
  vbpp = vinfo.bits_per_pixel ;
  line_len = finfo.line_length ;
  sprintf( tmp , "%d(pixel)x%d(line), %dbpp(bits per pixel)",xres,yres,vbpp);
  sprintf( tmp , "%d(xoffset)x%d(yoffset)",vinfo.xoffset, vinfo.yoffset);
  send_current_information( tmp );

  /* バイト単位でのスクリーンのサイズを計算 */
  screensize = xres * yres * vbpp / DIV_BYTE ;

  /* デバイスをメモリにマップする */
  fbptr = (char *)mmap(0,screensize,PROT_READ | PROT_WRITE,MAP_SHARED,fd_framebuffer,0);
  if ( (int)fbptr == -1 ) {
    send_current_error_msg("Don't get framebuffer device to memory !");
    exit(4);
  }
  send_current_information("The framebuffer device was mapped !");

  printf("fb: 0x%x \n", (unsigned int)fbptr);

  fb_t fb;
  fb.pixels = fbptr;
  fb.size = screensize;
  fb.width = xres;
  fb.height = yres;
  fb.bpp = vbpp;
  fb.fd = fd_framebuffer;

  return fb;

}

int main() {

  fb_t fb = get_fbdev_addr();

  void *p;
  Uint32 *gUra;

  gUra = (Uint32*)fb.pixels;
  //gUra = (Uint32*)malloc(fb.width*fb.height*4);

  printf("fb.height %d \n", fb.height);

  int i;
  int color = 0;

  for (i = 0; i < fb.width*fb.height; i++) {
    gUra[i] = color;
  }


  //初期化
  if (SDL_Init( SDL_INIT_VIDEO | SDL_INIT_TIMER | SDL_INIT_JOYSTICK ) < 0) {
    printf("SDL_Init failed\n");
    return -1;
  }

  printf("fb.width %d fb.height %d fb.bpp %d \n",fb.width, fb.height, fb.bpp);

  SDL_Surface *screen=SDL_SetVideoMode(fb.width,fb.height,fb.bpp,SDL_HWSURFACE);
  if (screen == NULL) {
    printf("SDL_Surface failed\n");
    SDL_Quit();
    return -1;
  }

  int done = 0;
  SDL_Event event;

  int fps=0;

  Uint32 t1=SDL_GetTicks();

  while(!done){
    while(SDL_PollEvent(&event)){
      switch(event.type){
      case SDL_QUIT:
        done = 1;
        break;
      case SDL_KEYDOWN:
        if(event.key.keysym.sym == SDLK_ESCAPE){
          done = 1;
        }
        break;
      }
    }

    if (color == 0xffffffff) {
      color = 0;
    } else {

      char r = ((color & redMask) >> 16) + 1;
      char g = ((color & greenMask) >> 8) + 1;
      char b = (color & blueMask) + 1;
	    
      color = alphaMask + (r << 16) + (g << 8) + b;

    }

    for (i = 0; i < fb.width*fb.height; i++) {
      gUra[i] = color;
    }

 
    if (SDL_GetTicks() < t1 + 1000){
      fps++;
    } else{
      printf("fps=%d\n", fps);
      fps=0;
      t1=SDL_GetTicks();
    }
  }

  for (i = 0; i < fb.width*fb.height; i++) {
    gUra[i] = 0;
  }
  munmap(fb.pixels, fb.size);
  close(fb.fd);
  SDL_Quit();


  return 0;

}

