#include <iostream>
#include "polygon_pack.h"
#include "spu_span.h"
using namespace std;


static float calc(float f1, float f2,int i, float base){
  float ans;
  ans = f1/f2*i + base;
  return ans;
}


static VertexPack *vMid1(VertexPack *vMid1,VertexPack *vMin, VertexPack *vMid, VertexPack *vMax) {
  float d,d1;
  d = (int)vMax->y-(int)vMin->y;
  d1 = (int)vMid->y - (int)vMin->y;
  vMid1->tex_x  = calc(vMax->tex_x - vMin->tex_x, d, (int)d1 , vMin->tex_x
		       );
  vMid1->tex_y  = calc(vMax->tex_y - vMin->tex_y, d, (int)d1 , vMin->tex_y
		       );
  vMid1->x      = calc(vMax->x - vMin->x, d, (int)d1 , vMin->x);
  vMid1->y      = vMid->y;
  vMid1->z      = calc(vMax->z - vMin->z, d, (int)d1 , vMin->z);
  //printf("x:%f y:%f z:%f tex_x:%f tex_y:%f\n",vMid1->x,vMid1->y,vMid1->z,vMid1->tex_x, vMid1->tex_y);
  return vMid1;
}

void half_triangle(SPUSPANLIST *ssl, long *tex_addr, long tex_width, long tex_height, VertexPack *vMin, VertexPack *vMid, VertexPack *vMid1) {
//void half_triangle(SPANPACK *sp, long *tex_addr, long tex_width, long tex_height, VertexPack *vMin, VertexPack *vMid, VertexPack *vMid1) {
  float tmp_z,tmp_tex1, tmp_tex2 ,tmp_tey1,tmp_tey2;
  float tmp_xpos,tmp_end,tmp_zpos;
  int i;
  //int j;
  float div_y;
  float start_z,end_z;
  float start_tex_x,end_tex_x,start_tex_y,end_tex_y;
  int x,y,length;
  int k =0;
  int l = 1;
  int start_y = (int)vMid->y;
  int end_y   = (int)vMin->y; 
        
  if (start_y<end_y) { 
    int i; i=end_y; end_y=start_y; start_y = i;
    k = 1;
    l = -1;
  }

  div_y = start_y - end_y;  // > 0

  //cout << "div_y : " << div_y+1 << endl;

  for(i = k; i < div_y+1; i++) {
    tmp_xpos = calc(vMid1->x - vMin->x ,div_y, i, vMin->x);
    tmp_end =  calc(vMid->x  - vMin->x ,div_y, i, vMin->x); 
    tmp_z =    calc(vMid1->z - vMin->z ,div_y, i, vMin->z);
    tmp_zpos = calc(vMid->z  - vMin->z ,div_y, i, vMin->z);
    //printf("x:%f end:%f z:%f zpos:%f\n",tmp_xpos,tmp_end,tmp_z,tmp_zpos);

    tmp_tex1 =((i/(div_y)) * vMid1->tex_x) + \
      ( ((div_y - i)/(div_y)) * vMin->tex_x); 
    tmp_tex2 =( (i/(div_y)) * vMid->tex_x) + \
      ( ((div_y - i)/(div_y)) * vMin->tex_x); 

    tmp_tey1 =( (i/(div_y)) * vMid1->tex_y) + \
      ( ((div_y - i)/(div_y)) * vMin->tex_y); 
    tmp_tey2 =( (i/(div_y)) * vMid->tex_y) + \
      ( ((div_y - i)/(div_y)) * vMin->tex_y); 
    if(tmp_xpos > tmp_end) {
      x = (int)tmp_end;
      y = (int)vMin->y + i*l;
      length = (int)(tmp_xpos)-(int)(tmp_end)+1;
      start_z = tmp_zpos;
      end_z = tmp_z;
      start_tex_x = tmp_tex2;
      end_tex_x = tmp_tex1;
      start_tex_y = tmp_tey2;
      end_tex_y = tmp_tey1;
    } else {
      x = (int)tmp_xpos;
      y = (int)vMin->y + i*l;
      length = (int)(tmp_end)-(int)(tmp_xpos)+1;
      start_z = tmp_z;
      end_z = tmp_zpos;
      start_tex_x = tmp_tex1;
      end_tex_x = tmp_tex2;
      start_tex_y = tmp_tey1;
      end_tex_y = tmp_tey2;
    }
    //printf("x:%d y:%d end:%d z:%f zpos:%f\n",x,y,length,start_z , end_z);
    //printf("start_tex_x:%f end_tex_x:%f start_tex_y:%f end_tex_y:%fn",start_tex_x,end_tex_x,start_tex_y,end_tex_y);

    //add(tex_addr,tex_width,tex_height,x,y,length,start_z,end_z,start_tex_x,end_tex_x,start_tex_y,end_tex_y);

    //y += 540;   // window_height = 1080  (1080/2 = 540)
    y += 240;   // window_height = 480  (480/2 = 240)

    int line_set = y/8;

    //y -= 540;   // window_height = 1080  (1080/2 = 540)
    y -= 240;   // window_height = 480  (480/2 = 240)

    int spu_no = line_set%6;
   
    int spp_no = line_set/6;
    int span_no = ssl->ss[spu_no].spp[spp_no].info.size;

    ssl->ss[spu_no].spp[spp_no].span[span_no].tex_addr = tex_addr;
    ssl->ss[spu_no].spp[spp_no].span[span_no].tex_width = tex_width;
    ssl->ss[spu_no].spp[spp_no].span[span_no].tex_height = tex_height;
    ssl->ss[spu_no].spp[spp_no].span[span_no].x = x;
    ssl->ss[spu_no].spp[spp_no].span[span_no].y = y;
    ssl->ss[spu_no].spp[spp_no].span[span_no].length_x = length;
    ssl->ss[spu_no].spp[spp_no].span[span_no].start_z = start_z;
    ssl->ss[spu_no].spp[spp_no].span[span_no].end_z = end_z;
    ssl->ss[spu_no].spp[spp_no].span[span_no].tex_x1 = start_tex_x;
    ssl->ss[spu_no].spp[spp_no].span[span_no].tex_x2 = end_tex_x;
    ssl->ss[spu_no].spp[spp_no].span[span_no].tex_y1 = start_tex_y;
    ssl->ss[spu_no].spp[spp_no].span[span_no].tex_y2 = end_tex_y;

    ssl->ss[spu_no].spp[spp_no].info.size++;
  }
}


int create_span(void *rbuf,void *wbuf) {
  //POLYGONPACK *polygon = (POLYGONPACK*)rbuf;
  PolygonPack *polygon = (PolygonPack*)rbuf;
  //SPANPACK *sp = (SPANPACK*)wbuf;
  //SPANPACKLIST *spl = (SPANPACKLIST*)wbuf;
  //SPANPACKLIST *spl = polygon->spl;
  SPUSPANLIST *ssl = polygon->ssl;
  VertexPack *vMin, *vMid, *vMax, *vMid10;
  VertexPack ver;
  vMid10 = &ver;

  //cout << "create_span:spl->size = " << spl->size << endl;
  //cout << "create_span:spl->dline[0].span = " << spl->dline[0].span << endl;

  //for(int i=0; i<spl->size; i++)
  for(int i=0; i<6; i++)  // 6 = number of SPU
    {
      ssl->ss[i].length = 0;
      //for(int t=0; t<10; t++)   // window_height = 1080  ( 1080/8/6 = 22.5 )
      for(int t=0; t<10; t++)    // window_height = 480  (480/8/6 = 10)
	{
	  ssl->ss[i].spp[t].info.size = 0;
	}
    }

  //sp->info.size = 0;

  //cout << sizeof(SPANPACK) << endl;
  //cout << "polygon size : " << polygon->info.size << endl;

  for(int a=0; a<polygon->info.size; a++) {
    //cout << "a = " << a << endl;
    //cout << "polygon size : " << polygon->info.size << endl;
    if(polygon->tri[a].ver1.y <= polygon->tri[a].ver2.y) {
      if(polygon->tri[a].ver2.y <= polygon->tri[a].ver3.y) {
	vMin = &polygon->tri[a].ver1;
	vMid = &polygon->tri[a].ver2;
	vMax = &polygon->tri[a].ver3;
      } else if(polygon->tri[a].ver3.y <= polygon->tri[a].ver1.y) {
	vMin = &polygon->tri[a].ver3;
	vMid = &polygon->tri[a].ver1;
	vMax = &polygon->tri[a].ver2;
      } else {
	vMin = &polygon->tri[a].ver1;
	vMid = &polygon->tri[a].ver3;
	vMax = &polygon->tri[a].ver2;
      }
    } else {
      if(polygon->tri[a].ver1.y <= polygon->tri[a].ver3.y) {
	vMin = &polygon->tri[a].ver2;
	vMid = &polygon->tri[a].ver1;
	vMax = &polygon->tri[a].ver3;
      } else if(polygon->tri[a].ver3.y <= polygon->tri[a].ver2.y) {
	vMin = &polygon->tri[a].ver3;
	vMid = &polygon->tri[a].ver2;
	vMax = &polygon->tri[a].ver1;
      } else {
	vMin = &polygon->tri[a].ver2;
	vMid = &polygon->tri[a].ver3;
	vMax = &polygon->tri[a].ver1;
      }
    }

    //cout << vMid->y << endl;
    //cout << vMin->y << endl;

    vMid1(vMid10,vMin,vMid,vMax);

    half_triangle(ssl,polygon->tri[a].tex_addr,polygon->tri[a].tex_width,polygon->tri[a].tex_height,vMin,vMid,vMid10);
    half_triangle(ssl,polygon->tri[0].tex_addr,polygon->tri[0].tex_width,polygon->tri[0].tex_height,vMax,vMid,vMid10);
    //printf("x:%d y:%d end:%d z:%f zpos:%f\n",sp->span[0].x,sp->span[0].y,sp->span[0].length_x,sp->span[0].start_z , sp->span[0].end_z);
  }
  //printf("create_span  x:%d y:%d end:%d z:%f zpos:%f\n",sp->span[0].x,sp->span[0].y,sp->span[0].length_x,sp->span[0].start_z , sp->span[0].end_z);
  return 0;

  //return sizeof(SPANPACKLIST);
}
