#include <iostream>
#include "polygon_pack.h"
#include "span_pack.h"
#include "spu_span.h"
using namespace std;

#define PIXELSIZE 11520 //32 line pixel size

int linebuf[2][8][IMG_MAX_Y];



void linebuf_init(int j) {
  int i;
  for(int t= 0; t < 8; t++) {
    for(i = 0; i < IMG_MAX_Y; i++) {
      linebuf[j][t][i] = 0;
    }
  }
}
char *get_pixel(int tx, int ty, void *texture_image)
{
  //return (char*)texture_image->pixels+(texture_image->format->BytesPerPixel*((texture_image->w)*ty+tx));
  return (char*)texture_image+(3*((128)*ty+tx));
}

Uint32 Polygon::get_rgb(int tx, int ty, void *texture)
{
  Uint8 red, green, blue;
  
  if (tx<0) tx = 0;
  if (128-1< tx) tx = 128-1 ;
  if (ty<0) ty = 0;
  if (128-1< ty) ty = 128-1 ;

  char *p = get_pixel(tx,ty,texture);

  blue  = (Uint8) p[0];
  green = (Uint8) p[1];
  red   = (Uint8) p[2];
	  
  SDL_PixelFormat pf;
  pf.BitsPerPixel = 32;
  pf.BytesPerPixel = 4;
  alpha = 255;

  return SDL_MapRGB(pf, red, green, blue);
}

void write_pixel(int x, int y, float z, Uint32 rgb)
{

}

void zRow_init() {
  int i;
  //printf("zRow_init?n");
  for(int t = 0; t < 8; t++) {
    for(i = 0; i < IMG_MAX_Y; i++) {
      zRow[t][i] = 65535;                
    }  
  }       
}

int spu_draw(SPUSPAN *ss, unsigned int fbdev_addr)
{
  void *texture = new void[128*128*3];
  long *addr = ss->sp[0].tex_addr;
  GLushort zRow[8][IMG_MAX_Y];
  static int j = 0;
  int render_y = 0;
  spu_mfcdma32(texture, addr, PIXELSIZE, 17, MFC_GET_CMD);
  spu_mfcdma32(texture+PIXELSIZE, addr+PIXELSIZE, PIXELSIZE, 18, MFC_GET_CMD);
  spu_mfcdma32(texture+PIXELSIZE*2, addr+PIXELSIZE*2, PIXELSIZE, 19, MFC_GET_CMD);
  spu_mfcdma32(texture+PIXELSIZE*3, addr+PIXELSIZE*3, PIXELSIZE, 20, MFC_GET_CMD);
  spu_writech(MFC_WrTagMask, 1 << 17);
  spu_mfcstat(MFC_TAG_UPDATE_ALL);
  spu_writech(MFC_WrTagMask, 1 << 18);
  spu_mfcstat(MFC_TAG_UPDATE_ALL);
  spu_writech(MFC_WrTagMask, 1 << 19);
  spu_mfcstat(MFC_TAG_UPDATE_ALL);
  spu_writech(MFC_WrTagMask, 1 << 20);
  spu_mfcstat(MFC_TAG_UPDATE_ALL);
  zRow_init();
  linebuf_init(j);
  render_y = ss->sp[0].span[0].y;
  for(int i; i<ss->length; i++)
    {
      for(int t; t<ss->sp[i].info.size; t++)
	{
	  int end = sp->span[n].length_x;
	  Uint32 rgb;
	  float tex1 = sp->span[n].tex_x1;
	  float tex2= sp->span[n].tex_x2;
	  float tey1 = sp->span[n].tex_y1;
	  float tey2= sp->span[n].tex_y2;
	  int tex_xpos;
	  int tex_ypos;
	  int tex_zpos;
	  int x = sp->span[n].x;
	  int y = sp->span[n].y;
	  float z = sp->span[n].start_z;
	  float zpos = sp->span[n].end_z;
	  float tex_x,tex_y,tex_z;
	  
	  if(end == 1) {
	    //printf("end == 1\n");
	    //printf("tex_x:%f tex_y:%f\n",tex1,tex2);
	    //if(tex1 > 1) tex1 = 1;
	    //if(tey1 > 1) tey1 = 1;
	    tex_xpos = (int)((sp->span[n].tex_height-1) * tex1);
	    tex_ypos = (int)((sp->span[n].tex_width-1) * tey1);
	    tex_zpos = (int)z;
	    //printf("tex_xpos:%d tex_ypos:%d\n",tex_xpos,tex_ypos);
	    //printf("image->h:%d tex_x:%f\n",(int)sp->span[n].tex_height,tex1);
	    if(z < zRow[x][y%8]) {
	      rgb = get_rgb(tex_xpos,tex_ypos);
	      //viewer->write_pixel(x,y,zpos,rgb);
	      linebuf[j][x][y%8] = rgb;
	    }

	  }else {
	    //printf("end != 1\n");
	    for(int j = 0; j < end; j++) {
	      tex_x = tex1*(end-1-j)/(end-1) + tex2*j/(end-1);
	      tex_y = tey1*(end-1-j)/(end-1) + tey2*j/(end-1);
	      tex_z = z*(end-1-j)/(end-1) + zpos*j/(end-1);
	      if(tex_x > 1) tex_x = 1;
	      if(tex_y > 1) tex_y = 1;
	      tex_xpos = (int)((sp->span[n].tex_height-1) * tex_x);
	      tex_ypos = (int)((sp->span[n].tex_width-1) * tex_y);
	      //printf("tex_xpos:%d tex_ypos:%d\n",tex_xpos,tex_ypos);
	      //printf("z:%f zpos:%f tex_z:%f\n",z,zpos,tex_z);
	      //printf("tex_x:%f tex_y:%f\n",tex_x,tex_y);
	      if(z < zRow[x][y%8]) {
		rgb = get_rgb(tex_xpos,tex_ypos);
		linebuf[j][x][y%8] = rgb;
		//viewer->write_pixel(j+x,y,tex_z,rgb);
	      }
	      }
	  }
	}
      writebuffer(j,fbdev_addr,render_y);
    }
  j ^= 1;
}

void writebuffer(int i,fbdev_addr,int y) {
  spu_mfcdma32(&linebuf[0][0],fbdev_addr,PIXELSIZE,21,MFC_PUT_CMD);
}
