#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include "CreatePolygonPack.h"
#include "polygon_pack.h"
#include "scene_graph_pack.h"


void
CreatePolygonPack::read(void)
{
     SchedTask::read();
}

int
CreatePolygonPack::run(void *rbuf, void *wbuf)
{
     SceneGraphPack *sgp = (SceneGraphPack*)rbuf;
     PolygonPack *pp = (PolygonPack*)wbuf;

     float xyz1[4],xyz2[4],xyz3[4];

     for (int i = 0; i < sgp->info.size; i++) {
	  SceneGraphNodePtr node = &sgp->node[i];
    
	  int n,nt,pt;
	  for(n=0,nt=0,pt=0; n<node->size*3; n+=9,nt+=6,pt++) {
	       xyz1[0] = node->vertex[n];
	       xyz1[1] = node->vertex[n+1];
	       xyz1[2] = node->vertex[n+2]*-1;
	       xyz1[3] = 1;
	       xyz2[0] = node->vertex[n+3];
	       xyz2[1] = node->vertex[n+3+1];
	       xyz2[2] = node->vertex[n+3+2]*-1;
	       xyz2[3] = 1;
	       xyz3[0] = node->vertex[n+6];
	       xyz3[1] = node->vertex[n+6+1];
	       xyz3[2] = node->vertex[n+6+2]*-1;
	       xyz3[3] = 1;

	       rotate(xyz1, node->translation);
	       rotate(xyz2, node->translation);
	       rotate(xyz3, node->translation);

	       pp->tri[pt].ver1.x = xyz1[0];
	       pp->tri[pt].ver1.y = xyz1[1];
	       pp->tri[pt].ver1.z = xyz1[2];
	       pp->tri[pt].ver1.tex_x = node->texture[nt];
	       pp->tri[pt].ver1.tex_y = node->texture[nt+1];

	       pp->tri[pt].ver2.x = xyz2[0];
	       pp->tri[pt].ver2.y = xyz2[1];
	       pp->tri[pt].ver2.z = xyz2[2];
	       pp->tri[pt].ver2.tex_x = node->texture[nt+2];
	       pp->tri[pt].ver2.tex_y = node->texture[nt+2+1];

	       pp->tri[pt].ver3.x = xyz3[0];
	       pp->tri[pt].ver3.y = xyz3[1];
	       pp->tri[pt].ver3.z = xyz3[2];
	       pp->tri[pt].ver3.tex_x = node->texture[nt+4];
	       pp->tri[pt].ver3.tex_y = node->texture[nt+4+1];

	       pp->tri[pt].tex_width = node->tex_width;
	       pp->tri[pt].tex_height = node->tex_height;
	  }
	  pp->info.size = pt;
	  pp->ssl = sgp->ssl;
     }

     return sizeof(PolygonPack);
}

void
CreatePolygonPack::write(void)
{
     SchedTask::write();

     free(readbuf);
     free(writebuf);
}

void
CreatePolygonPack::rotate(float *xyz, float *matrix)
{
     float abc[4];

     abc[0] = xyz[0];
     abc[1] = xyz[1];
     abc[2] = xyz[2];
     abc[3] = xyz[3];
    
     // SIMD 使えるよね
     for (int i=0; i<4; i++)
     {
	  xyz[i] = abc[0]*matrix[i] + abc[1]*matrix[i+4]
	       + abc[2]*matrix[i+8] + abc[3]*matrix[i+12];
     }
}

SchedTask*
createTask_createPolygonPack(TaskListPtr _taskList, TaskPtr _task,
			     void *rbuff, void *wbuff, DmaManager *dma)
{
     rbuff = memalign(16, sizeof(SceneGraphPack));
     wbuff = memalign(16, sizeof(PolygonPack));

     return new CreatePolygonPack(_taskList, _task, rbuff, wbuff, dma);
}
