#include <iostream>
#include "scene_graph_pack.h"
#include "polygon.h"
using namespace std;

int create_sgp(Polygon *sg, SceneGraphPack *sgp)
{
    int i = 0;
    int nnpn = -1;
    SceneGraphNodePtr node;

    Polygon *t;
    t = sg;
    
    while(t)
    {
	node = &sgp->node[i];

	node->size = t->size;
	int d,tex;
	for(d=0,tex=0; d<t->size*3; d+=3,tex+=2)
	{
	    node->vertex[d] = t->data[d];
	    node->vertex[d+1] = t->data[d+1];
	    node->vertex[d+2] = t->data[d+2];
	    node->texture[tex] = t->data[d+t->size*6];
	    node->texture[tex+1] = t->data[d+t->size*6+1];
	}

	node->obj_pos[0] = 0;
	node->obj_pos[1] = 0;
	node->obj_pos[2] = 0;
	node->obj_pos[3] = 1;
	node->angle[0] = 0;
	node->angle[1] = 0;
	node->angle[2] = 0;
	node->angle[3] = 1;

	for(int tm=0; tm<16; tm++)
        {
	    node->translation[tm] = 0;
        }
	node->id = 0;
	node->move = 0;
	node->interaction = 0;
	node->pn = nnpn;

	//node->tex_addr = t->texture_image->pixels;
	node->tex_width = t->texture_image->w;
	node->tex_height = t->texture_image->h;

	if(t->child != NULL)
	{
	    nnpn = i;
	    t = t->child;
	}
	else if(t->brother != NULL)
	{
	    nnpn = node->pn;
	    t = t->brother;
	}
	else
	{
	    while(t)
	    {
		if(t->brother != NULL)
		{
		    t = t->brother;
		    break;
		}
		else
		{
		    if(t->parent == NULL)
		    {
			t = NULL;
			break;
		    }
		    nnpn = sgp->node[nnpn].pn;
		    t = t->parent;
		}
	    }
	}
	i++;
    }
    sgp->info.size = i;

    return sizeof(SceneGraphPack);
}
