#include <iostream>
#include "viewer.h"
#include "TaskManager.h"
#include "error.h"

int init(void*, void*);
int finish(void*, void*);


Viewer *screen;
TaskManager *manager;

struct init_arg {
	int bpp;
	int w;
	int h;
};

struct init_arg *initArg;

int init(void *r, void *w) {
	int fd_sdl_init,fd_run;
	HTaskPtr task_sdl_init, task_run;

	__debug("[%s]\n",__FUNCTION__);

	screen = new Viewer(initArg->bpp, initArg->w, initArg->h);

	fd_sdl_init = manager->open("sdl_init");
	fd_run      = manager->open("run");

	task_sdl_init = manager->create_task(fd_sdl_init, 0, 0, 0, NULL);
	task_run      = manager->create_task(fd_run, 0, 0, 0, NULL);

 	task_run->set_depend(task_sdl_init);

	task_sdl_init->spawn();
	task_run->spawn();

	free(initArg);
	return 0;
}

int sdl_init(void *r , void *w) {
	
	__debug("[%s]\n", __FUNCTION__);
	screen->sdl_init();
	return 0;
}

int run(void *r, void *w) {
	
	__debug("[%s]\n", __FUNCTION__);
	screen->run_init();
	return 0;
}

int finish(void *w, void *r)
{
	__debug("[%s]\n", __FUNCTION__);
	delete screen;
	delete manager;
	return 0;
}


int main(int argc, char *argv[]) {
	manager = new TaskManager(1);
	manager->init();

	//task_initialize();
	
	manager->set_symbol("init", (void*)init);
	manager->set_symbol("sdl_init", (void*)sdl_init);
	manager->set_symbol("run", (void*)run);
	manager->set_symbol("finish", (void*)finish);

	int bpp = 0;
	int width = 640;
	int height = 480;

	for(int i = 1; argv[i]; ++i) {
		if (strcmp(argv[i], "-bpp") == 0) {
			bpp = atoi(argv[++i]);
		} 
		if (strcmp(argv[i], "-width") == 0) {
			width = atoi(argv[++i]);
		} 
		if (strcmp(argv[i], "-height") == 0) {
			height = atoi(argv[++i]);
		}
	}
	HTaskPtr task_init;
	int fd_init;
	initArg = new struct init_arg;
	initArg->bpp = bpp;
	initArg->w   = width;
	initArg->h   = height;

	fd_init = manager->open("init");
	task_init = manager->create_task(fd_init, 0, 0, 0, NULL);
	task_init->spawn();
	manager->run();
	finish(NULL, NULL);
	return 0;
}

