#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "TaskManager.h"
#include "Func.h"

#define DATA_NUM 12

extern void task_init();

static int task = 1;

const char *usr_help_str = "Usage: ./twice [-length data_length] [-count task_num]\n\
  -length  Number of data (default DATA_NUM (Func.h))\n\
  -count   Number of task (default 1)\n";


void
print_data(int *data, int size, const char *title)
{
    printf("%s ---\n", title);
    for (int i = 0; i < size; i++) {
	printf("%2d ", data[i]);
    }
    printf("\n");
}

/**
 * タスク終了後の data1, data2 の確認
 */
void
twice_result(SchedTask *s, void *a, void *b)
{
    int* data = (int*)a;
    int length = (long)b;
    print_data(data, length, "after");
    free(data);
}

int length = DATA_NUM;

int
init(int argc, char **argv)
{
    for (int i = 1; argv[i]; ++i) {
        if (strcmp(argv[i], "-length") == 0) {
            length = atoi(argv[++i]);
        } else if (strcmp(argv[i], "-count") == 0) {
            task = atoi(argv[++i]);
        }
    }

    return 0;
}

void
twice_init(TaskManager *manager)
{
    HTask *twice;

    int *data = (int*)manager->allocate(sizeof(int)*length);
    int *out  = (int*)manager->allocate(sizeof(int)*length);

    for (int i = 0; i < length; i++) {
	data[i] = i;
    }

    print_data(data, length, "before");

    /**
     * Create Task
     *   create_task(Task ID);
     */ 
    twice = manager->create_task(Twice,(memaddr)data,sizeof(int)*length, (memaddr)out, sizeof(int)*length);
    twice->set_cpu(SPE_ANY);
    
    twice->set_post(twice_result, (void*)out, (void*)length);

    // add Active Queue
    twice->spawn();    
}

int
TMmain(TaskManager *manager,int argc, char *argv[])
{
    if (init(argc, argv) < 0) {
	return -1;
    }

    // Task Register
    //   ppe/task_init.cc
    task_init();

    for (int i = 0; i < task; ++i) {
	twice_init(manager);
    }

    return 0;
}

/* end */
