#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "TaskManager.h"
#include "Func.h"

extern void task_init(void);

int *idata;
int length = DATA_NUM;
int depend_flg = 1;

const char *usr_help_str = "Usage: ./dependency [-cpu spe_num] [-nodepend]\n\
  -nodepend  No Depenendcy";

void
run_start(TaskManager *manager)
{
    HTaskPtr t_exec[2];
    HTaskPtr t_print;

    idata = (int*)manager->allocate(sizeof(int)*length*2);
    for (int i = 0; i < length*2; i++) {
	idata[i] = 0;
    }

    // exec1,2 が計算した配列を見る
    t_print = manager->create_task(TASK_PRINT);
    t_print->add_inData(idata, sizeof(int)*length*2);
    t_print->add_param((memaddr)(length*2));

    // idata を二つに分けて計算する
    for (int i = 0; i < 2; i++) {
	t_exec[i] = manager->create_task(TASK_EXEC);
	t_exec[i]->add_inData(&idata[length*i], sizeof(int)*length);
	t_exec[i]->add_outData(&idata[length*i], sizeof(int)*length);
	t_exec[i]->add_param((memaddr)length);
	t_exec[i]->add_param((memaddr)(13*(i+1)));
	t_exec[i]->set_cpu(SPE_ANY);

	if (depend_flg)
	    t_print->wait_for(t_exec[i]);
    }

    // add Active Queue
    t_print->spawn();

    for (int i = 0; i < 2; i++) {
	t_exec[i]->spawn();
    }
}

int
init(int argc, char **argv)
{
    for (int i = 1; argv[i]; ++i) {
	if (strcmp(argv[i], "-nodepend") == 0) {
	    depend_flg = 0;
	}
    }

    return 0;
}

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    if (init(argc, argv) < 0) {
	return -1;
    }

    task_init();
    run_start(manager);

    return 0;
}
