#include <stdio.h>
#include "RenewStart.h"
#include "SpeProfile.h"
#include "Func.h"

/* これは必須 */
SchedDefineTask(RenewStart);

static int
run(SchedTask *s, void *rbuf, void *wbuf)
{
    s->printf("[SPE] ** running RenewStart\n");
    
    void *tmp =  s->global_alloc(sizeof(SpeProfile), 0);
    // overlay で動くの?
    SpeProfile *profile = new (tmp) SpeProfile;

    int id = (long)s->get_param(0);
    s->printf("[SPE] Create Task : Renew1 %d\n", id);
    HTaskPtr nextTask =  s->create_task(RENEW1);

    int *test_num = (int*)s->get_param(1);
    int *local_num = (int*)s->allocate(sizeof(int));
    *local_num = 555;

    // この add_inData は、メインメモリのアドレスになる。
    nextTask->add_inData(test_num, sizeof(int));
    // local なアドレスを渡したい時には、set_param を使う。
    nextTask->add_param(local_num);

    nextTask->spawn();
    
    s->printf("[SPE] ** finish  RenewStart\n\n");

    profile->ProfStart();

    return 0;
}
