#include <stdio.h>
#include <string.h>
#include "Load.h"
#include "Func.h"

/* これは必須 */
SchedDefineTask(Load);

static int
run(SchedTask *s, void *rbuf, void *wbuf)
{
    int *idata = (int*)s->get_input(rbuf, 0);
    int *odata = (int*)s->global_get(DATA_ID);
    long length = (long)s->get_param(0);

    // SPU LS 内に領域確保し、データをコピー
    odata = (int*)s->global_alloc(DATA_ID, sizeof(int)*length);
    memcpy(odata, idata, sizeof(int)*length);

    s->printf("[TASK_LOAD]    ");
    for (int i = 0; i < length; i++) {
	s->printf("%03d ", idata[i]);
    }
    s->printf("\n");

    return 0;
}
