using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using ChaKi.Entity.Search;
using ChaKi.GUICommon;

namespace ChaKi.Panels.ConditionsPanes
{
    public partial class FilterPane : UserControl
    {
        private FilterCondition m_Model;

        internal FilterButton FilterButton { get; set; }  // PaneŊǗACommand Panelɕ\ԃ{^m_Model.AllEnabled̒l𔽉fB

        public FilterPane(FilterCondition model)
        {
            m_Model = model;
            m_Model.OnModelChanged += new EventHandler( this.ModelChangedHandler );

            InitializeComponent();

            this.FilterButton = new FilterButton();
            this.FilterButton.IsOn = m_Model.AllEnabled;
            this.FilterButton.Click += new EventHandler(FilterButton_Click);

            UpdateView();
        }

        public void SetCondition(FilterCondition cond)
        {
            m_Model = cond;
            m_Model.OnModelChanged += new EventHandler(this.ModelChangedHandler);
            UpdateView();
        }

        public FilterCondition GetCondition()
        {
            Synchronize();
            return m_Model;
        }

        public void PerformFilterAutoIncrement()
        {
            if (m_Model.AllEnabled
                && m_Model.ResultsetFilter.FetchType == FetchType.Incremental
                && m_Model.ResultsetFilter.IsAutoIncrement)
            {
                m_Model.ResultsetFilter.StartAt += m_Model.ResultsetFilter.Max;
                UpdateView();
            }
        }

        private void UpdateView()
        {
            bool b = m_Model.AllEnabled;
            this.checkBox1.Checked = b;
            this.FilterButton.IsOn = b;
            this.filterControl.Enabled = b;

            this.filterControl.UpdateView(m_Model);
        }

        /// <summary>
        /// ݂Control̏ԂɂModeleXVB
        /// </summary>
        private void Synchronize()
        {
            m_Model.AllEnabled = this.checkBox1.Checked;
            this.filterControl.Synchronize(m_Model);
        }

        public void ModelChangedHandler(object sender, EventArgs e)
        {
            UpdateView();
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            bool b = this.checkBox1.Checked;

            m_Model.AllEnabled = b;
            this.filterControl.Enabled = b;
            this.FilterButton.IsOn = b;
        }

        // Command PanelłFilterButtonNbNCxgnh
        void FilterButton_Click(object sender, EventArgs e)
        {
            bool b = !this.FilterButton.IsOn;

            m_Model.AllEnabled = b;
            this.checkBox1.Checked = b;
            this.filterControl.Enabled = b;
            this.FilterButton.IsOn = b;
        }
    }
}
