﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using ChaKi.Common;
using ChaKi.Common.Settings;

namespace ChaKi
{
    public partial class SplashScreen : Form
    {
        DoWorkEventHandler m_BackgroundWork;

        public SplashScreen(DoWorkEventHandler backgroundWork)
        {
            InitializeComponent();

            m_BackgroundWork = backgroundWork;
            this.backgroundWorker1.DoWork += new DoWorkEventHandler(m_BackgroundWork);
            this.backgroundWorker1.RunWorkerCompleted += new RunWorkerCompletedEventHandler(backgroundWorker1_RunWorkerCompleted);

            this.button1.Enabled = false;
            this.button2.Enabled = false;

            this.Shrink = true;
        }

        public string UserName
        {
            get { return this.textBox1.Text; }
        }

        public string Password
        {
            get { return this.textBox2.Text; }
        }

        void backgroundWorker1_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            if (e.Error != null)
            {
                MessageBox.Show(e.Error.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                this.DialogResult = DialogResult.Cancel;
                return;
            }
            if (GUISetting.Instance.AutoLogon)
            {
                this.DialogResult = DialogResult.Abort;
            }
            else
            {
                this.button1.Enabled = true;
                this.button2.Enabled = true;
            }
        }

        public string ProgressMsg
        {
            set { this.progressMsg.Text = value; }
        }

        public bool Shrink
        {
            set
            {
                if (value)
                {
                    this.Height = 80;
                }
                else
                {
                    this.Height = 200;
                }
            }
        }

        private void SplashScreen_Load(object sender, EventArgs e)
        {
            this.backgroundWorker1.RunWorkerAsync(this);
        }

        /// <summary>
        /// Logon Clicled
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button1_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
        }

        /// <summary>
        /// Cancel clicked
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button2_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
        }
    }
}
