﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ChaKi.Entity.Settings;

namespace ChaKi.ToolDialogs
{
    public partial class ExportGridToExcelDialog : Form
    {
        private ExportSetting m_Model;

        public ExportGridToExcelDialog()
        {
            InitializeComponent();
        }

        public void SetModel(ExportSetting model)
        {
            m_Model = new ExportSetting(model);
        }

        public ExportSetting GetModel()
        {
            UpdateModel();
            return new ExportSetting(m_Model);
        }

        private void UpdateView()
        {
            this.radioButton1.Checked = (m_Model.ExportType == ExportType.Excel);
            this.radioButton2.Checked = (m_Model.ExportType == ExportType.CSV);
        }

        private void UpdateModel()
        {
            if (this.radioButton1.Checked) m_Model.ExportType = ExportType.Excel;
            if (this.radioButton2.Checked) m_Model.ExportType = ExportType.CSV;
        }

        private void ExportGridToExcelDialog_Load(object sender, EventArgs e)
        {
            // Excelが存在するかチェック
            if (ExportToExcelDialog.CheckExcelExistence())
            {
                this.radioButton1.Enabled = false;
                m_Model.ExportType = ExportType.CSV;
            }
            else
            {
                m_Model.ExportType = ExportType.Excel;
            }
            UpdateView();
        }
    }
}
