﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Serialization;
using System.IO;
using ChaKi.Entity.Corpora;

namespace ChaKi.Common.Settings
{
    public class PropertyBoxSettings
    {
        public static PropertyBoxSettings Instance
        {
            get
            {
                if (m_Instance == null)
                {
                    m_Instance = new PropertyBoxSettings();
                }
                return m_Instance;
            }
        }
        private static PropertyBoxSettings m_Instance;

        public List<PropertyBoxItemSetting> Settings { get; set; }

        public event EventHandler SettingChanged;

        public PropertyBoxSettings()
        {
            this.Settings = new List<PropertyBoxItemSetting>();
        }

        public PropertyBoxSettings(PropertyBoxSettings src)
            : this()
        {
            CopyFrom(src);
        }

        public void CopyFrom(PropertyBoxSettings src)
        {
            this.Settings.Clear();
            foreach (PropertyBoxItemSetting s in src.Settings)
            {
                this.Settings.Add(new PropertyBoxItemSetting(s));
            }
            if (SettingChanged != null)
            {
                SettingChanged(this, null);
            }
        }

        public static void Clear()
        {
            Instance.Settings.Clear();
        }

        public static void Default()
        {
            Default(Instance.Settings);
        }

        public static void Default(IList<PropertyBoxItemSetting> list)
        {
            list.Clear();
            foreach (KeyValuePair<LP, string> pair in Lexeme.PropertyName)
            {
                list.Add(new PropertyBoxItemSetting(pair.Value));
            }
        }

        public static void Load(string file)
        {
            Clear();
            using (StreamReader rd = new StreamReader(file))
            {
                XmlSerializer ser = new XmlSerializer(typeof(PropertyBoxSettings));
                m_Instance = (PropertyBoxSettings)ser.Deserialize(rd);
            }
        }

        public static void Save(string file)
        {
            using (StreamWriter wr = new StreamWriter(file))
            {
                XmlSerializer ser = new XmlSerializer(typeof(PropertyBoxSettings));
                ser.Serialize(wr, Instance);
            }
        }
    }


    public class PropertyBoxItemSetting
    {
        public PropertyBoxItemSetting()
        {
            this.TagName = string.Empty;
            this.DisplayName = string.Empty;
            this.IsVisible = false;
        }

        public PropertyBoxItemSetting(string tagName)
        {
            this.TagName = tagName;
            this.DisplayName = tagName;
            this.IsVisible = true;
        }

        public PropertyBoxItemSetting(string tagName, string displayName, bool isVisible)
        {
            this.TagName = tagName;
            this.DisplayName = displayName;
            this.IsVisible = isVisible;
        }

        public PropertyBoxItemSetting(PropertyBoxItemSetting src)
        {
            this.TagName = src.TagName;
            this.DisplayName = src.DisplayName;
            this.IsVisible = src.IsVisible;
        }

        public string TagName { get; set; }
        public string DisplayName { get; set; }
        public bool IsVisible { get; set; }
    }
}
