﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace ChaKi.Common.Wdigets
{
    public partial class ProgressDialog : Form, IProgress
    {
        public DoWorkEventHandler Work { get; set; }
        public object WorkerParameter { get; set; }
        public bool Canceled { get; private set; }
        public event EventHandler WorkerCancelled;

        private BackgroundWorker m_Worker;

        public ProgressDialog()
        {
            InitializeComponent();

            this.Text = "Processing...";
            this.ProgressMax = 100;
            this.ProgressReset();
            this.Canceled = false;
            this.Load += new EventHandler(ProgressDialog_Load);
            m_Worker = null;
        }

        private void DisposeImpl()
        {
            if (m_Worker != null)
            {
                m_Worker.Dispose();
            }
        }

        void ProgressDialog_Load(object sender, EventArgs e)
        {
            if (this.Work != null)
            {
                m_Worker = new BackgroundWorker();
                m_Worker.WorkerReportsProgress = true;
                m_Worker.DoWork += this.Work;
                m_Worker.ProgressChanged += new ProgressChangedEventHandler(OnWorkerProgressChanged);
                m_Worker.RunWorkerAsync(WorkerParameter);
            }
        }

        void OnWorkerProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            this.ProgressCount = e.ProgressPercentage;
        }

        public bool CancelEnabled
        {
            set
            {
                this.button1.Enabled = value;
            }
        }

        public int ProgressMax
        {
            set
            {
                if (this.IsHandleCreated)
                {
                    var action = new Action<int>(v => this.progressBar1.Maximum = v);
                    if (this.InvokeRequired)
                    {
                        this.Invoke(action, value);
                    }
                    else
                    {
                        action(value);
                    }
                }
            }
        }

        public int ProgressCount
        {
            set
            {
                if (this.IsHandleCreated)
                {
                    var action = new Action<int>(v => this.progressBar1.Value = v);
                    if (this.InvokeRequired)
                    {
                        this.Invoke(action, value);
                    }
                    else
                    {
                        action(value);
                    }
                }
            }
        }

        public void ProgressReset()
        {
            if (this.IsHandleCreated)
            {
                var action = new Action(() => { this.progressBar1.Value = 0; });
                if (this.InvokeRequired)
                {
                    this.Invoke(action);
                }
                else
                {
                    action();
                }
            }
        }

        public void EndWork()
        {
            this.DialogResult = DialogResult.Cancel;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            this.Canceled = true;
            if (WorkerCancelled != null)
            {
                WorkerCancelled(sender, e);
            }
        }
    }
}
