using System;
using System.IO;

namespace CreateCorpusSLA
{
    class Program
    {
        static void Main(string[] args)
        {
            CreateCorpus cc = new CreateCorpus();

            Console.WriteLine("args={0}\n", string.Join(",", args));

            if (!cc.ParseArguments(args))
            {
                PrintUsage();
                goto Exit;
            }
            if (cc.CreateSeparateDB)
            {
                // ^[QbgDBłꍇ́A̓tH_̊et@Cɂă[v
                // SQLitȅꍇ:
                //   o͂ƂătH_pXw肵ꍇɂɗ.
                //   o͂́Aw肳ꂽtH_̉A̓t@C̃t@C+".db"ƂÕt@C
                // MySQL̏ꍇ:
                //   "Separate Database"`FbN{bNXONɂꍇɂɗ.
                //   o͂́A̓t@C̃t@CƓÕf[^x[X
                string ipath = cc.InputPath;
                if (!CreateCorpus.PathIsFolder(ipath))
                {
                    Console.WriteLine("Input Path must be a folder name when -p is set.");
                    goto Exit;
                }
                string opath = cc.CorpusName;
                string folder = string.Empty;
                if (CreateCorpus.PathIsFolder(opath))
                {
                    folder = opath;
                }
                else
                {
                    folder = Path.GetDirectoryName(opath);
                }
                string[] files = Directory.GetFileSystemEntries(ipath);
                foreach (string s in files)
                {
                    if (CreateCorpus.PathIsFolder(s)) continue;

                    cc.InputPath = s;
                    cc.CorpusName = Path.GetFileNameWithoutExtension(s);
                    cc.ForceCheckInputExtension = true;
                    if (cc.DbType == "SQLite")
                    {
                        // tH_Ɗgqǉ
                        cc.CorpusName = string.Format("{0}\\{1}.db", folder, cc.CorpusName);
                    }
                    DoJobs(cc);
                }
            }
            else
            {
                DoJobs(cc);
            }
            if (cc.DoNotPauseOnExit)
            {
                return;
            }
        Exit:
            Console.WriteLine("\nPress Enter to exit.");
            Console.ReadLine();
        }

        static private void DoJobs(CreateCorpus cc)
        {
            DateTime t0 = DateTime.Now;
            Console.WriteLine("[{0}]: Started at {1}", cc.InputPath, t0.ToLocalTime());

            cc.InitializeDocumentSet();

            if (!cc.CheckInput()) return;

            if (cc.IsCreatingDictionary)
            {
                if (!cc.ParseDictionaryInput()) return;
                if (!cc.SaveLexicon()) return;
            }
            else
            {
                if (!cc.ParseBibFile()) return;
                if (!cc.ParseInput()) return;
                if (!cc.SaveProject()) return;
                if (!cc.SaveLexicon()) return;
                if (!cc.SaveSentences()) return;
                if (!cc.SaveSentenceTags()) return;
                if (!cc.UpdateIndex()) return;
            }
            DateTime t1 = DateTime.Now;
            TimeSpan elapsed = t1 - t0;
            Console.WriteLine("Done.");
            Console.WriteLine("Finished at {0}; Elapsed {1} minutes", t1.ToLocalTime(), elapsed.TotalMinutes);
        }

        static void PrintUsage()
        {
            Console.WriteLine("Usage: CreateCorpus [Options] <InputFile> <Output>");
            Console.WriteLine("Options:");
            Console.WriteLine("  [-e=<encoding>] Input Encoding (SHIFT_JIS)");
            Console.WriteLine("  [-t=<type>]     Reader Type; See ReaderDefs.xml (Auto)");
            Console.WriteLine("  [-b=<bibfile>]  Use external .bib file");
            Console.WriteLine("  [-l=<dicfile>]  Use external dictionary");
            Console.WriteLine("  [-d]            Create Dictionary instead of Corpus");
            Console.WriteLine("  [-s]            Set SQLite Synchronous Write mode (false)");
            Console.WriteLine("  [-p]            Make different database for each input when read from folder (false)");
            Console.WriteLine("  [-C]            Do not pause on exit (false)");
            Console.WriteLine("InputFile         cabocha/chasen/mecab/text file");
            Console.WriteLine("Output            .db file for SQLite / .def file for Others / .ddb file for SQLite Dictionary");
        }
    }
}
