﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ChaKi.Entity.Search
{
    public class FilterCondition : ISearchCondition, ICloneable
    {
        public bool AllEnabled { get; set; }
        public string DocumentFilter { get; set; }
        public ResultsetFilter ResultsetFilter;

        public event EventHandler OnModelChanged;

        public FilterCondition()
        {
            Reset();
        }

        public FilterCondition(FilterCondition src)
        {
            this.AllEnabled = src.AllEnabled;
            this.DocumentFilter = src.DocumentFilter;
            this.ResultsetFilter = src.ResultsetFilter;
            this.OnModelChanged = src.OnModelChanged;
        }

        public object Clone()
        {
            return new FilterCondition(this);
        }

        public void Reset()
        {
            this.AllEnabled = false;
            this.DocumentFilter = string.Empty;
            this.ResultsetFilter.Reset();

            if (OnModelChanged != null) OnModelChanged(this, null);
        }
    }
}
