﻿using System;
using ChaKi.Entity.Corpora;
using ChaKi.Entity.Corpora.Annotations;
using NHibernate;

namespace ChaKi.Service.DependencyEdit
{
    internal class OperationAddItemToWordGroup : Operation
    {
        private CharRange m_Range;
        private Group m_Group;
        private Segment m_Segment;

        public OperationAddItemToWordGroup(Group g, CharRange range)
        {
            m_Range = range;
            m_Group = g;
        }

        public override void Execute(DepEditContext ctx)
        {
            if (m_Group == null || m_Range == null)
            {
                throw new NullReferenceException();
            }
            Segment seg = new Segment();
            seg.Sentence = ctx.Sen;
            seg.Doc = ctx.Sen.ParentDoc;
            seg.Tag = ctx.Proj.FindTag(Tag.SEGMENT, m_Group.Tag.Name);
            seg.StartChar = m_Range.Start.Value + ctx.Sen.StartChar;
            seg.EndChar = m_Range.End.Value + ctx.Sen.StartChar;
            seg.Proj = ctx.Proj;
            seg.User = ctx.User;
            seg.Version = seg.Tag.Version;
            ctx.Save(seg);
            m_Segment = seg;
            m_Group.Tags.Add(seg);
            ctx.Flush();
        }

        public override void UnExecute(DepEditContext ctx)
        {
            if (m_Group == null || m_Segment == null)
            {
                throw new NullReferenceException();
            }
            m_Group.Tags.Remove(m_Segment);
            ctx.Delete(m_Segment);
            ctx.Flush();
        }

        public override string ToIronRubyStatement(DepEditContext ctx)
        {
            return string.Format("#svc.AddItemToWordGroup({0}, c+({1}), c+({2})) : not supported.",
                m_Group.ID, m_Range.Start + ctx.Sen.StartChar - ctx.CharOffset, m_Range.End + ctx.Sen.StartChar - ctx.CharOffset);
        }

        public override string ToString()
        {
            return string.Format("{{OperationAddItemToWordGroup:{0}}}", m_Range);
        }
    }
}
