﻿using System;
using ChaKi.Entity.Corpora;
using ChaKi.Entity.Corpora.Annotations;
using NHibernate;

namespace ChaKi.Service.DependencyEdit
{
    internal class OperationMergeBunsetsu : Operation
    {
        private int m_DocId;
        private int m_BPos;
        private int m_EPos;
        private int m_SPos;

        public OperationMergeBunsetsu(int docid, int bpos, int epos, int spos)
        {
            m_DocId = docid;
            m_BPos = bpos;
            m_EPos = epos;
            m_SPos = spos;
        }

        public override void Execute(DepEditContext ctx)
        {
            ExecuteMergeBunsetsuOperation(m_DocId, m_BPos, m_EPos, ctx);
            // 重複関連であるWord-Segmentを割り当て直す.
            UpdateWordToSegmentRelations(ctx);
        }

        public override void UnExecute(DepEditContext ctx)
        {
            ExecuteSplitBunsetsuOperation(m_DocId, m_BPos, m_EPos, m_SPos, ctx);
            // 重複関連であるWord-Segmentを割り当て直す.
            UpdateWordToSegmentRelations(ctx);
        }

        public override string ToIronRubyStatement(DepEditContext ctx)
        {
            return string.Format("svc.MergeBunsetsu(d, c+({0}), c+({1}), c+({2}))",
                m_BPos - ctx.CharOffset, m_EPos - ctx.CharOffset, m_SPos - ctx.CharOffset);
        }

        public override string ToString()
        {
            return string.Format("{{OperationMergeBunsetsu:{0}, {1}, {2}, {3}}}", m_DocId, m_BPos, m_EPos, m_SPos);
        }
    }
}
