﻿using System;
using ChaKi.Entity.Corpora;
using ChaKi.Entity.Corpora.Annotations;
using NHibernate;

namespace ChaKi.Service.DependencyEdit
{
    internal class OperationMoveArrow : Operation
    {
        private Link m_Link;
        private Segment m_SegmentOld;
        private Segment m_SegmentNew;

        public OperationMoveArrow(Link lnk, Segment segOld, Segment segNew)
        {
            m_Link = lnk;
            m_SegmentOld = segOld;
            m_SegmentNew = segNew;
        }

        public override void Execute(DepEditContext ctx)
        {
            if (m_Link == null || m_SegmentNew == null)
            {
                throw new NullReferenceException();
            }
            m_SegmentOld = m_Link.To;
            m_Link.To = m_SegmentNew;
            ctx.Flush();
        }

        public override void UnExecute(DepEditContext ctx)
        {
            if (m_Link == null || m_SegmentOld == null)
            {
                throw new NullReferenceException();
            }
            m_Link.To = m_SegmentOld;
            ctx.Flush();
        }

        public override string ToIronRubyStatement(DepEditContext ctx)
        {
            return string.Format("#svc.ChangeLinkEnd({0}, {1}, {2}) : not supported.",
                m_Link.ID, m_SegmentOld.ID, m_SegmentNew.ID);
        }

        public override string ToString()
        {
            return string.Format("{{OperationMoveArrow:link={0}, segold={1}, segnew={2}}}", m_Link.ID, m_SegmentOld.ID, m_SegmentNew.ID);
        }
    }
}
