﻿using System.Collections.Generic;
using ChaKi.Entity.Corpora;

namespace ChaKi.Service.Lexicons
{
    public interface ILexiconService
    {
        void Open(Corpus cps);

        void Close();

        /// <summary>
        /// Surfaceがstrに一致するLexemeをすべて得る。
        /// </summary>
        /// <param name="str"></param>
        IList<Lexeme> Search(string str);

        /// <summary>
        /// 与えられたLexemeと一致するLexemeの数を返す。
        /// 完全なLexemdを与えた場合は結果はFrequencyフィールドそのものである。
        /// 一部属性がnullのLexemeを与えた場合は、マッチするLexemeすべてのFrequencyを合計したものである。
        /// </summary>
        /// <param name="lex"></param>
        /// <returns></returns>
        int QueryFrequency(Lexeme lex);

    }
}
