﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ChaKi.KwicView
{
    internal class Selection
    {
        private bool m_RangeSelection;  // Start-Endの指定ならtrue, List指定ならfalse
        public int Start;
        public int End;
        public List<int> Selections;

        public Selection()
        {
            m_RangeSelection = true;
            this.Selections = new List<int>();
        }

        public void Clear()
        {
            this.Selections.Clear();
            this.Start = 0;
            this.End = 0;
        }

        public void SetRange(int start, int end)
        {
            this.Start = start;
            this.End = end;
            m_RangeSelection = true;
        }

        public void AddSelection(int index)
        {
            this.Selections.Add(index);
            m_RangeSelection = false;
        }

        public void RemoveSelection(int index)
        {
            if (m_RangeSelection)
            {
                throw new InvalidOperationException("Removing item from Range Selection");
            }
            this.Selections.Remove(index);
        }

        public bool IsValid()
        {
            if (m_RangeSelection)
            {
                return (End > Start);
            }
            return (Selections.Count > 0);
        }

        public bool Contains(int index)
        {
            if (m_RangeSelection)
            {
                return (index >= Start && index <= End);
            }
            return Selections.Contains(index);
        }
    }
}
