using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ChaKi.Entity.Corpora;

namespace ChaKi.Panels
{
    public partial class ContextPanel : Form
    {
        public SentenceContext Model { get; set; }

        public ContextPanel()
        {
            this.Model = new SentenceContext();

            InitializeComponent();
            this.richTextBox1.Font = GUISetting.Instance.GetBaseTextFont();

            GUISetting.Instance.FontChanged += new EventHandler(OnFontChanged);
        }

        public void UpdateView()
        {
            Color fg = this.richTextBox1.ForeColor;
            Color bg = this.richTextBox1.BackColor;
            this.richTextBox1.Clear();

            this.richTextBox1.SelectionColor = fg;
            this.richTextBox1.SelectionBackColor = bg;
            foreach (string s in Model.Pre)
            {
                this.richTextBox1.SelectedText = s;
            }
            this.richTextBox1.SelectionColor = Color.Yellow;
            this.richTextBox1.SelectionBackColor = Color.Brown;
            foreach (string s in Model.Center)
            {
                this.richTextBox1.SelectedText = s;
            }
            this.richTextBox1.SelectionColor = fg;
            this.richTextBox1.SelectionBackColor = bg;
            foreach (string s in Model.Post)
            {
                this.richTextBox1.SelectedText = s;
            }
        }

        void OnFontChanged(object sender, EventArgs e)
        {
            this.Font = GUISetting.Instance.GetBaseTextFont();
        }
    }
}