﻿using System.Collections.Generic;
using System.Windows.Forms;
using ChaKi.Entity.Corpora;
using System.Diagnostics;

namespace ChaKi.Panels
{
    public partial class TagListPanel : Form
    {
        public List<DocumentTag> Model { get; set; }

        public TagListPanel()
        {
            this.Model = new List<DocumentTag>();

            InitializeComponent();
        }

        public void UpdateView()
        {
            Stopwatch sw = new Stopwatch();
            sw.Reset();
            sw.Start();
            DataGridView dg = this.dataGridView1;
                for (int i = dg.Rows.Count; i < this.Model.Count; i++)
                {
                    dg.Rows.Add();
                }
            if (this.Model == null) 
            {
                return;
            }
            for (int i = 0; i < dg.Rows.Count; i++)
            {
                if (i < this.Model.Count)
                {
                    DocumentTag tag = this.Model[i];
                    dg[0, i].Value = tag.Tag;
                    dg[1, i].Value = tag.Description;
                }
                else
                {
                    dg[0, i].Value = string.Empty;
                    dg[1, i].Value = string.Empty;
                }
            }
            sw.Stop();
            Debug.WriteLine(string.Format("UpdateView t={0}", sw.ElapsedMilliseconds));
        }
    }
}
