﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ChaKi.Entity.Settings;

namespace ChaKi
{
    public partial class CreateSQLiteCorpus : Form
    {
        public CreateSQLiteCorpus()
        {
            InitializeComponent();

            this.comboBox1.SelectedItem = UserSettings.GetInstance().DefaultCorpusSourceEncoding;
            this.comboBox2.SelectedItem = UserSettings.GetInstance().DefaultCorpusSourceType;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            string args = "";
            if (this.comboBox1.Text.Length > 0)
            {
                args += string.Format("-e={0} ", this.comboBox1.Text);
            }
            if (this.comboBox2.Text.Length > 0)
            {
                args += string.Format("-t={0} ", this.comboBox2.Text);
            }
            args += string.Format("\"{0}\" \"{1}\"", this.textBox2.Text, this.textBox3.Text);
            this.process1.StartInfo.Arguments = args;
            this.process1.StartInfo.WorkingDirectory = Program.ProgramDir;
            this.process1.Start();
        }

        private void process1_Exited(object sender, EventArgs e)
        {
            this.Close();
        }

        private void button4_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            OpenFileDialog dlg = new OpenFileDialog();
            dlg.CheckFileExists = true;
            dlg.Title = "Select Input File";
            dlg.Filter = "Input files (*.cabocha)|*.cabocha|ChaSen files (*.chasen)|*.chasen|MeCab files (*.mecab)|*.mecab|All files (*.*)|*.*";
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                this.textBox2.Text = dlg.FileName;
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            OpenFileDialog dlg = new OpenFileDialog();
            dlg.CheckFileExists = false;
            dlg.Title = "Select Output SQLite DB File";
            dlg.Filter = "SQLite database files (*.db)|*.db|All files (*.*)|*.*";
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                this.textBox3.Text = dlg.FileName;
            }
        }

        private void CreateSQLiteCorpus_FormClosing(object sender, FormClosingEventArgs e)
        {
            UserSettings.GetInstance().DefaultCorpusSourceEncoding = this.comboBox1.Text;
            UserSettings.GetInstance().DefaultCorpusSourceType = this.comboBox2.Text;
        }

    }
}
