﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using ChaKi.Entity.Corpora;
using ChaKi.Entity.Kwic;
using ChaKi.Common;
using ChaKi.Entity.Search;

namespace ChaKi.Views.KwicView
{
    public partial class KwicView : UserControl, IChaKiView
    {
        public bool TwoLineMode
        {
            get
            {
                return this.kwicViewPanel1.TwoLineMode;
            }
            set
            {
                this.kwicViewPanel1.TwoLineMode = value;
                this.kwicViewPanel1.CalculateLineHeight();
                this.kwicViewPanel1.UpdateKwicList();
            }
        }

        public bool KwicMode
        {
            get
            {
                return this.kwicViewPanel1.KwicMode;
            }
            set
            {
                this.kwicViewPanel1.SuspendUpdateView = true;
                this.kwicViewPanel1.KwicMode = value;
                this.kwicViewPanel1.WordWrap = !value;
                // Columnヘッダをモードに合わせて変更
                for (int i = 0; i < Columns.NColumns; i++)
                {
                    if (value)
                    {
                        this.dataGridView1.Columns[i].HeaderText = Columns.DefaultHeaderTextKwic[i];
                        this.dataGridView1.Columns[i].Width = Columns.DefaultHeaderWidthKwic[i];
                    }
                    else
                    {
                        this.dataGridView1.Columns[i].HeaderText = Columns.DefaultHeaderTextNonKwic[i];
                        this.dataGridView1.Columns[i].Width = Columns.DefaultHeaderWidthNonKwic[i];
                    }
                    m_Columns.Widths[i] = this.dataGridView1.Columns[i].Width;
                    Invalidate(true);
                }
                this.kwicViewPanel1.SuspendUpdateView = false;
            }
        }

        private Columns m_Columns;

        #region KwicView Events
        /// <summary>
        /// Current行が変化したときの親(MainForm)への通知
        /// （子Panelからの中継）
        /// </summary>
        public event CurrentChangedDelegate CurrentChanged;
        /// <summary>
        /// Context表示指示時の親(MainForm)への通知 
        /// （子Panelからの中継）
        /// </summary>
        public event RequestContextDelegate ContextRequested;
        /// <summary>
        /// Guide Panelの表示更新通知 
        /// （子Panelからの中継）
        /// </summary>
        public event UpdateGuidePanelDelegate UpdateGuidePanel;
        #endregion

        public KwicView()
        {
            InitializeComponent();

            m_Columns = new Columns();

            // Event Handlerの割り当て
            this.kwicViewPanel1.OnContextRequested += new RequestContextDelegate(kwicViewPanel1_OnContextRequested);
            this.kwicViewPanel1.OnCurrentChanged += new CurrentChangedDelegate(kwicViewPanel1_OnCurrentChanged);
            this.kwicViewPanel1.OnUpdateGuidePanel += new UpdateGuidePanelDelegate(kwicViewPanel1_OnUpdateGuidePanel);
        }

        public void SetModel(object model)
        {
            if (model != null && !(model is SearchHistory))
            {
                throw new ArgumentException("Assigning invalid model to KwicPanel");
            }
            this.kwicViewPanel1.SetModel((SearchHistory)model);
        }

        //TODO: MainForm.LoadAnnotations()を改良したら削除するべきメソッド
        public void UpdateSegments()
        {
            this.kwicViewPanel1.UpdateAnnotations();
        }

        public void SetVisible(bool f)
        {
            this.Visible = f;
        }

        public void RecalcLayout()
        {
            this.kwicViewPanel1.RecalcLayout();
        }

        public int GetCurrentCenterWordID()
        {
            return 0;
        }

        public void DeleteAll()
        {
            this.kwicViewPanel1.DeleteAll();
        }

        public void AutoAdjustColumnWidths()
        {
            m_Columns.AutoAdjust(this.kwicViewPanel1.EffectiveWidth, this.KwicMode);
            if (this.KwicMode)
            {
                this.dataGridView1.Columns[5].Width = Columns.DefaultHeaderWidthKwic[5];
                this.dataGridView1.Columns[7].Width = Columns.DefaultHeaderWidthKwic[7];
            }
            else
            {
                this.dataGridView1.Columns[7].Width = Columns.DefaultHeaderWidthNonKwic[7];
            }
            Invalidate(true);
        }

        public void LeftAdjustColumnWidths()
        {
        }

        public void ShiftPivot(int shift)
        {
            this.kwicViewPanel1.ResetUpdateStatus();
            this.kwicViewPanel1.UpdateKwicList();
        }

        private void dataGridView1_ColumnWidthChanged(object sender, DataGridViewColumnEventArgs e)
        {
            if (m_Columns == null)
            {
                return;
            }
            for (int i = 0; i < Columns.NColumns; i++)
            {
                m_Columns.Widths[i] = this.dataGridView1.Columns[i].Width;
            }
            this.kwicViewPanel1.OnWidthChanged(m_Columns);
        }

        void kwicViewPanel1_OnUpdateGuidePanel(Lexeme lex)
        {
            if (this.UpdateGuidePanel != null)
            {
                UpdateGuidePanel(lex);
            }
        }

        void kwicViewPanel1_OnContextRequested(KwicList list, int row)
        {
            if (this.ContextRequested != null)
            {
                ContextRequested(list, row);
            }
        }

        void kwicViewPanel1_OnCurrentChanged(Corpus cps, int senid)
        {
            if (this.CurrentChanged != null)
            {
                CurrentChanged(cps, senid);
            }
        }

        private void dataGridView1_ColumnHeaderMouseClick(object sender, DataGridViewCellMouseEventArgs e)
        {
            int colno = e.ColumnIndex;
            SortOrder order = this.dataGridView1.Columns[colno].HeaderCell.SortGlyphDirection;
            this.kwicViewPanel1.Sort(colno, order);
        }
    }
}
