using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Data.Common;
using ChaKi.Entity.Properties;
using System.Xml.Serialization;
using System.Collections.ObjectModel;
using System.Collections;
using System.Diagnostics;
using ChaKi.Entity.Corpora.Annotations;

namespace ChaKi.Entity.Corpora
{
    public class Corpus
    {
        public string Name
        {
            get { return DBParam.Name; }
        }

        public DBParameter DBParam { get; set; }

        // ePvl(DBService.LoadCorpusInfo()Ŏ擾)
        public long NLexemes { get; set; }
        public long NWords { get; set; }
        public int NSentences { get; set; }
        public int NBunsetsus { get; set; }
        public int NSegments { get; set; }
        public int NLinks { get; set; }
        public int NGroups { get; set; }

        public Corpus()
        {
            this.DBParam = new DBParameter();
            this.Sentences = new List<Sentence>();
            this.Lex = new Lexicon();
            this.Segments = new List<Segment>();
            this.Links = new List<Link>();
            this.DocumentTags = new List<DocumentTag>();
        }

        public static Corpus CreateFromFile(string path)
        {
            Corpus c = new Corpus();
            string ext = Path.GetExtension(path).ToUpper();
            // nameSQLitȅꍇDB(pXjAʏDB`t@C
            if (ext.Equals(".DEF"))
            {
                //deft@CǂݍŊep[^𓾂
                c.DBParam.ParseDefFile(path);
            }
            else if (ext.Equals(".DB"))
            {
                c.DBParam.DBType = "SQLite";
                c.DBParam.DBPath = path;
                c.DBParam.Name = Path.GetFileNameWithoutExtension(path);
            }
            return c;
        }

        // ̃R[pXɑΉDocumentSet̊Ǘ
        [XmlIgnore]
        public DocumentSet DocumentSet { get; set; }

        // ̊Ǘ
        [XmlIgnore]
        public List<Sentence> Sentences { get; set; }

        public void AddSentence(Sentence sen)
        {
            this.Sentences.Add(sen);
        }

        // Lexicon̊Ǘ
        [XmlIgnore]
        public Lexicon Lex { get; set; }

        // Segment̊Ǘ
        [XmlIgnore]
        public List<Segment> Segments { get; set; }

        // Link̊Ǘ
        [XmlIgnore]
        public List<Link> Links { get; set; }

        public virtual void AddSegment(Segment seg)
        {
            this.Segments.Add(seg);
        }

        public virtual void AddLink(Link lnk)
        {
            this.Links.Add(lnk);
        }
        
        // DOcumentTag̊Ǘ
        [XmlIgnore]
        public List<DocumentTag> DocumentTags { get; set; }

        public virtual void AddDocumentTag(DocumentTag tag)
        {
            this.DocumentTags.Add(tag);
        }


        /// <summary>
        /// R[pX̊{CorpusPropertỹXgƂĕԂ.
        /// </summary>
        /// <returns></returns>
        public List<CorpusProperty> GetCorpusProperties()
        {
            List<CorpusProperty> cprops = new List<CorpusProperty>();
            cprops.Add(new CorpusProperty("Name", this.Name));
            cprops.Add(new CorpusProperty("DBType", this.DBParam.DBType));
            cprops.Add(new CorpusProperty("Path", this.DBParam.DBPath));
            cprops.Add(new CorpusProperty("Server", this.DBParam.Server));
            cprops.Add(new CorpusProperty("User", this.DBParam.User));
            string dummy = new string('*', this.DBParam.Password.Length);
            cprops.Add(new CorpusProperty("Password", dummy));
            cprops.Add(new CorpusProperty("#Words", this.NWords.ToString()));
            cprops.Add(new CorpusProperty("#Lexemes", this.NLexemes.ToString()));
            cprops.Add(new CorpusProperty("#Sentences", this.NSentences.ToString()));
            cprops.Add(new CorpusProperty("#Bunsetsu", this.NBunsetsus.ToString()));
            cprops.Add(new CorpusProperty("#Segments", this.NSegments.ToString()));
            cprops.Add(new CorpusProperty("#Links", this.NLinks.ToString()));
            cprops.Add(new CorpusProperty("#Groups", this.NGroups.ToString()));
            return cprops;
        }
    }
}
