using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Corpora;
using System.Xml.Serialization;
using System.Xml;
using System.Xml.Schema;

namespace ChaKi.Entity.Kwic
{
    public class KwicItem : IXmlSerializable
    {
        public KwicItem()
        {
            Left = new KwicPortion(this);
            Center = new KwicPortion(this);
            Right = new KwicPortion(this);

            ID = 0;
            Crps = null;
            SenPos = 0;
            StartCharPos = 0;
        }

        /// <summary>
        /// KwicItem쐬
        /// IDKwicListɒǉ(AddKwicItem)ƂɎtB
        /// </summary>
        /// <param name="c"></param>
        /// <param name="senPos"></param>
        /// <param name="charPos"></param>
        public KwicItem(Corpus c, int senPos, int startCharPos, int endCharPos)
        {
            Left = new KwicPortion(this);
            Center = new KwicPortion(this);
            Right = new KwicPortion(this);

            ID = 0; // KwicListɒǉ(AddKwicItem)ƂɎtB
            Crps = c;
            SenPos = senPos;
            StartCharPos = startCharPos;
            EndCharPos = endCharPos;
        }

        /// <summary>
        /// 
        /// </summary>
        public KwicPortion Left { get; set; }
        /// <summary>
        /// Si̎gp͖Ήj
        /// </summary>
        public KwicPortion Center { get; set; }
        /// <summary>
        /// E
        /// </summary>
        public KwicPortion Right { get; set; }

        /// <summary>
        /// ɕt^鍀ڂ̒ʂԍ
        /// </summary>
        public int ID { get; set; }
        /// <summary>
        /// KwicItem̑Corpus
        /// </summary>
        public Corpora.Corpus Crps { get; set; }
        /// <summary>
        /// R[pXłKwicItemn܂镶ʒu
        /// </summary>
        public int StartCharPos { get; set; }
        /// <summary>
        /// R[pXłKwicItemI镶ʒu
        /// </summary>
        public int EndCharPos { get; set; }
        /// <summary>
        /// R[pXł̂KwicItem̕ԍ
        /// </summary>
        public int SenPos { get; set; }

        /// <summary>
        /// IԂɂ邩ۂtO
        /// </summary>
        public bool Checked { get; set; }

        public int Offset
        {
            get { return m_Offset; }
        }

        /// <summary>
        /// CenterVtg.
        /// A𒴂ăVtgƂ̕KwicWord.
        /// </summary>
        /// <param name="shift"></param>
        public void Shift(int shift)
        {
            if (shift == 0)
            {
                return;
            }
            KwicWord w = null;
            if (shift > 0)
            {
                //  EVtg
                for (int i = 0; i < shift; i++)
                {
                    if (this.Left.Count > 0)
                    {
                        w = this.Left.PopBack();
                        m_Offset--;
                    }
                    else
                    {
                        w = new KwicWord();
                    }
                    this.Center.PushFront(w);
                    w = Center.PopBack();
                    this.Right.PushFront(w);
                }
            }
            else
            {
                //  Vtg
                for (int i = 0; i < -shift; i++)
                {
                    if (this.Right.Count > 0)
                    {
                        w = this.Right.PopFront();
                    }
                    else
                    {
                        w = new KwicWord();
                    }
                    this.Center.PushBack(w);
                    w = this.Center.PopFront();
                    m_Offset++;
                    this.Left.PushBack(w);
                }
            }
        }

        /// <summary>
        /// wʒuKwicWordHilightZbg.
        /// </summary>
        /// <param name="pos"></param>
        /// <param name="f"></param>
        public void SetHilight(int pos, bool f)
        {
            if (pos == 0)
            {
                foreach (KwicWord w in this.Center.Words)
                {
                    int attr = w.ExtAttr;
                    if (f)
                    {
                        attr |= KwicWord.KWA_HILIGHT;
                    }
                    else
                    {
                        attr &= (~KwicWord.KWA_HILIGHT);
                    }
                    w.ExtAttr = attr;
                }
            }
            if (pos < 0 && this.Left.Count + pos >= 0)
            {
                KwicWord w = this.Left.Words[this.Left.Count + pos];
                int attr = w.ExtAttr;
                if (f)
                {
                    attr |= KwicWord.KWA_HILIGHT;
                }
                else
                {
                    attr &= (~KwicWord.KWA_HILIGHT);
                }
                w.ExtAttr = attr;
            }
            else if (pos > 0 && pos - 1 < this.Right.Count)
            {
                KwicWord w = this.Right.Words[pos - 1];
                int attr = w.ExtAttr;
                if (f)
                {
                    attr |= KwicWord.KWA_HILIGHT;
                }
                else
                {
                    attr &= (~KwicWord.KWA_HILIGHT);
                }
                w.ExtAttr = attr;
            }
        }

        public void WriteXml(XmlWriter writer)
        {
            string s = string.Format("{0},{1},{2},{3},{4},{5},{6},{7}",
                ID, Crps.Name, StartCharPos, SenPos, Checked, Left.ToString(), Center.ToString(), Right.ToString());
            writer.WriteCData(s);
        }

        public void ReadXml(XmlReader reader)
        {
            throw new NotImplementedException();
        }

        public XmlSchema GetSchema()
        {
            return (null);
        }


        #region Private Fields
        /// <summary>
        /// tɂi\[gŎgpj
        /// </summary>
        private KwicPortion Left_Rev;

        /// <summary>
        /// \ShiftɁA݂center̈ʒu
        /// ꕪOɂĂ邩l
        /// </summary>
        private int m_Offset;
        #endregion
    }
}
