using System;
using System.Collections.Generic;
using ChaKi.Entity.Corpora;
using System.Xml.Serialization;

namespace ChaKi.Entity.Search
{
    public class CorpusCondition : ISearchCondition, ICloneable
    {
        public List<Corpus> Corpora { get; set; }
        public event EventHandler OnModelChanged;

        public CorpusCondition()
        {
            Corpora = new List<Corpus>();
        }

        public CorpusCondition(CorpusCondition src)
        {
            Corpora = new List<Corpus>();
            foreach (Corpus c in src.Corpora)
            {
                // CorpusCloneIuWFNgԂłĂL
                Corpora.Add(c);
            }
            OnModelChanged = src.OnModelChanged;
        }

        public object Clone()
        {
            return new CorpusCondition(this);
        }

        public void Reset()
        {
            Corpora.Clear();
            if (OnModelChanged != null) OnModelChanged(this, null);
        }
    }
}
