using System;
using System.Collections.Generic;
using System.Text;

namespace ChaKi.Entity.Search
{
    public class SearchConditions : ICloneable
    {
        /// <summary>
        /// ConditionsSequence̒OConditionsƂ錟̏WZq(None,And,Or)
        /// ʂ̉ZɂẮASearchConditionsSequenceNXQ
        /// </summary>
        public SearchSequenceOperator Operator { get; set; }
        public SearchType ActiveSearch { get; set; }
        public CorpusCondition CorpusCond { get; set; }
        public FilterCondition FilterCond { get; set; }
        public StringSearchCondition StringCond { get; set; }
        public TagSearchCondition TagCond { get; set; }
        public DepSearchCondition DepCond { get; set; }
        public CollocationCondition CollCond { get; set; }

        public SearchConditions()
        {
            this.Operator = SearchSequenceOperator.None;
            this.ActiveSearch = SearchType.Undefined;
            this.CorpusCond = new CorpusCondition();
            this.FilterCond = new FilterCondition();
            this.StringCond = new StringSearchCondition();
            this.TagCond = new TagSearchCondition();
            this.DepCond = new DepSearchCondition();
            this.CollCond = new CollocationCondition();
        }

        public SearchConditions(SearchConditions src)
        {
            this.Operator = src.Operator;
            this.ActiveSearch = src.ActiveSearch;
            this.CorpusCond = new CorpusCondition(src.CorpusCond);
            this.FilterCond = new FilterCondition(src.FilterCond);
            this.StringCond = new StringSearchCondition(src.StringCond);
            this.TagCond = new TagSearchCondition(src.TagCond);
            this.DepCond = new DepSearchCondition(src.DepCond);
            this.CollCond = new CollocationCondition(src.CollCond);
        }

        public void Reset()
        {
            this.Operator = SearchSequenceOperator.None;
            this.ActiveSearch = SearchType.Undefined;
            this.CorpusCond.Reset();
            this.FilterCond.Reset();
            this.StringCond.Reset();
            this.TagCond.Reset();
            this.DepCond.Reset();
            this.CollCond.Reset();
        }

        public object Clone()
        {
            SearchConditions obj = new SearchConditions(this);
            return obj;
        }
    }
}
