﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Corpora;
using ChaKi.Entity.Kwic;
using ChaKi.Service.Database;
using NHibernate;
using ChaKi.Service.Search;
using ChaKi.Entity.Corpora.Annotations;

namespace ChaKi.Service.Annotation
{
    public class AnnotationService
    {
        public AnnotationService()
        {
        }

        /// <summary>
        /// KwicListに含まれるSentenceに関連するAnnotationをすべてCorpusより取得する
        /// </summary>
        /// <param name="src"></param>
        /// <param name="result"></param>
        public void Load(KwicList src, AnnotationList result, Action<int> callback, ref bool cancelFlag)
        {
            Corpus currentCorpus = null;
            foreach (KwicItem ki in src.Records)
            {
                if (currentCorpus != ki.Crps)
                {
                    if (currentCorpus == null)
                    {
                        currentCorpus = ki.Crps;
                    } else {
                        throw new NotSupportedException("Cannot obtain annotations for a KwicList containing multiple corpora.");
                    }
                }
            }
            if (currentCorpus == null) {
                return;
            }

            result.Clear();

            DBService dbs = DBService.Create(currentCorpus.DBParam);
            NHibernate.Cfg.Configuration cfg = dbs.GetConnection();
            ISessionFactory factory = cfg.BuildSessionFactory();
            int total = src.Records.Count;
            using (ISession session = factory.OpenSession())
            {
                List<int> senPosList = new List<int>();
                foreach (KwicItem ki in src.Records)
                {
                    senPosList.Add(ki.SenPos);
                }
                if (senPosList.Count < 0)
                {
                    return;
                }
                else if (senPosList.Count == 1)
                {
                    FetchAnnotations(senPosList[0], session, result, callback);
                }
                else
                {
                    FetchAnnotations(senPosList, session, result, callback, ref cancelFlag);
                }
            }
        }

        private void FetchAnnotations(int senPos, ISession session, AnnotationList result, Action<int> callback)
        {
            string qstr = string.Format("from Segment s where s.Sentence.ID = {0}", senPos);
            IQuery query = session.CreateQuery(qstr);
            IList<Segment> segs = query.List<Segment>();
            result.Segments.AddRange(segs);

            qstr = string.Format("from Link k where k.FromSentence.ID = {0} or k.ToSentence.ID = {0}", senPos);
            query = session.CreateQuery(qstr);
            IList<Link> links = query.List<Link>();
            result.Links.AddRange(links);
            if (callback != null)
            {
                callback(100);
            }
        }

        private void FetchAnnotations(List<int> senPosList, ISession session, AnnotationList result, Action<int> callback, ref bool cancelFlag)
        {
            int total = senPosList.Count;
            StringBuilder sb = new StringBuilder();
            StringConnector sc = new StringConnector(",");

            for (int i = 0; i < senPosList.Count; i++)
            {
                if (cancelFlag)
                {
                    return;
                }
                int senPos = senPosList[i];
                sb.Append(sc.Get());
                sb.AppendFormat("{0}", senPos);

                if (i % 500 == 499 || i == senPosList.Count - 1)
                {
                    string slist = sb.ToString();

                    string qstr = string.Format("from Segment s where s.Sentence.ID in ({0})", slist);
                    IQuery query = session.CreateQuery(qstr);
                    IList<Segment> segs = query.List<Segment>();
                    result.Segments.AddRange(segs);

                    qstr = string.Format("from Link k where k.FromSentence.ID in ({0}) or k.ToSentence.ID in ({0})", slist);
                    query = session.CreateQuery(qstr);
                    IList<Link> links = query.List<Link>();
                    result.Links.AddRange(links);

                    if (callback != null)
                    {
                        callback(100 * i / total);
                    }
                    sb.Length = 0;
                    sc.Reset();
                }
            }
        }
    }
}
