﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Corpora;
using ChaKi.Entity.Corpora.Annotations;

namespace ChaKi.Service.DependencyEdit
{
    public class DepEditServiceSLA : DepEditService
    {
        /// <summary>
        /// 指定した文節を指定した語位置で分離する。
        /// </summary>
        /// <param name="bpos">文節の開始文字位置</param>
        /// <param name="epos">文節の終了文字位置</param>
        /// <param name="spos">分割文字位置</param>
        public void SplitBunsetsu(int bpos, int epos, int spos)
        {
            DepOperation op = new DepOperationSLA(DOType.Split, new object[] { bpos, epos, spos });
            op.Execute(m_Sentence, m_Session);
            m_History.Record(op);
        }

        /// <summary>
        /// 指定した文節を次の文節と併合する。
        /// </summary>
        /// <param name="bpos">文節の開始文字位置</param>
        /// <param name="epos">文節の終了文字位置</param>
        /// <param name="spos">分割文字位置</param>
        public void MergeBunsetsu(int bpos, int epos, int spos)
        {
            DepOperation op = new DepOperationSLA(DOType.Merge, new object[] { bpos, epos, spos });
            op.Execute(m_Sentence, m_Session);
            m_History.Record(op);
        }

        public void ChangeLinkEnd(Link link, Segment oldseg, Segment newseg)
        {
            DepOperation op = new DepOperationSLA(DOType.MoveArrow, new object[] { link, oldseg, newseg });
            op.Execute(m_Sentence, m_Session);
            m_History.Record(op);
        }

        public void ChangeLinkTag(Link link, string oldtag, string newtag)
        {
            DepOperation op = new DepOperationSLA(DOType.MoveArrow, new object[] { link, oldtag, newtag });
            op.Execute(m_Sentence, m_Session);
            m_History.Record(op);
        }
    }
}
