﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Corpora;

namespace ChaKi.Service.Readers
{
    internal class CabochaBunsetsuList : Dictionary<string, CabochaBunsetsu>
    {
        public void Add(CabochaBunsetsu obj)
        {
            string key = string.Format("{0}-{1}", obj.Sen.StartChar, obj.BunsetsuPos);
            if (!ContainsKey(key))
                base.Add(key, obj);
        }

        public CabochaBunsetsu Find(Sentence sen, int bunsetsuPos)
        {
            string key = string.Format("{0}-{1}", sen.StartChar, bunsetsuPos);
            CabochaBunsetsu ret;
            this.TryGetValue(key, out ret);
            return ret;
        }
    }
}
