﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Corpora;
using System.IO;
using ChaKi.Entity.Corpora.Annotations;

namespace ChaKi.Service.Readers
{
    public class PlainTextReader : CorpusSourceReader
    {
        private Corpus m_Corpus;
        private TagSet m_TagSet;

        public PlainTextReader(Corpus corpus)
        {
            m_Corpus = corpus;
            m_TagSet = new TagSet("Dummy");    // Empty TagSet
        }

        public Document ReadFromFile(string path, string encoding)
        {
            Document newdoc = new Document();

            LexiconBuilder lb = new LexiconBuilder();

            using (TextReader streamReader = new StreamReader(path, Encoding.GetEncoding(encoding)))
            {
                int n = 0;
                int charPos = 0;
                string s;

                newdoc.FileName = path;

                // TextはStringBuilderに生成しておいて、最後にDocumentに割り当てる.
                StringBuilder sb = new StringBuilder();

                while ((s = streamReader.ReadLine()) != null)
                {
                    Sentence sen = new Sentence(newdoc);
                    sb.Append(s);
                    sen.StartChar = charPos;
                    m_Corpus.AddSentence(sen);
                    charPos += s.Length;
                    sen.EndChar = charPos;

                    Lexeme m = lb.AddEntry(s);
                    if (m != null)
                    {
                        Word w = sen.AddWord(m);
                        //TODO: 英語の場合：平文を再現するにはデリミタで単語を区切る必要がある

                        w.StartChar = sen.StartChar;
                        w.EndChar = sen.EndChar;
                    }

                    // 文全体に対して文節を追加
                    Segment seg = new Segment();
                    seg.StartChar = sen.StartChar;
                    seg.EndChar = sen.EndChar;
                    seg.Tag = new Tag(Tag.SEGMENT, "Bunsetsu"); //TODO: Tagは単一インスタンスを共用しなければならい。
                    m_Corpus.AddSegment(seg);
                    Segment dummy = new Segment();
                    dummy.StartChar = sen.EndChar;
                    dummy.EndChar = sen.EndChar;
                    dummy.Tag = new Tag(Tag.SEGMENT, "Bunsetsu"); //TODO: Tagは単一インスタンスを共用しなければならい。
                    m_Corpus.AddSegment(dummy);
                    Link link = new Link();
                    link.From = seg;
                    link.To = dummy;
                    link.Tag = new Tag(Tag.LINK, "D"); //TODO: Tagは単一インスタンスを共用しなければならい。
                    m_Corpus.AddLink(link);

                    Console.Write("> {0}\r", ++n);
                }
                newdoc.Text = sb.ToString();
            }
            return newdoc;
        }

        public Document ReadFromFileSLA(string path, string encoding)
        {
            return ReadFromFile(path, encoding);
        }

        public TagSet GetTagSet()
        {
            return m_TagSet;
        }
    }
}
