﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Search;
using NHibernate;
using System.Collections;
using ChaKi.Entity.Corpora;
using ChaKi.Entity.Kwic;

namespace ChaKi.Service.Search
{
    public class DepSearchService : SearchServiceBase
    {
        private KwicList m_Model;
        private LexemeResultSet m_LexemeResultSet;  //中間結果としてのLexemeリストのリスト

        public DepSearchService(KwicList model, SearchConditionsSequence condSeq, CommandProgress progress)
            : base(condSeq, progress)
        {
            m_Model = model;
            m_LexemeResultSet = null;
        }

        /// <summary>
        /// コーパスごとのDepSearch本体
        /// </summary>
        /// <param name="c"></param>
        protected override void ExecuteSearchSession(Corpus c)
        {
            SearchConditions cond = m_CondSeq.Last;  //TODO: 絞り込み等ではCondSeqを順次検索しなければならない

            // Lexemeの検索条件文(HQL)を作成し、検索結果を得る
            m_LexemeResultSet = QueryBunsetsuLexemeResultSet(cond.DepCond);
            if (m_LexemeResultSet == null || m_LexemeResultSet.Count == 0)
            {
                m_Progress.SetRange(0);     // ヒットなし
                return;
            }

            // Wordの検索条件文(HQL)を作成し、検索を実行する。
            string qstr = QueryBuilder.Instance.BuildDepSearchQuery(m_LexemeResultSet, cond);
            IQuery query = m_Session.CreateQuery(qstr);
            IList queryResult = query.List();
            int totalCount = queryResult.Count;

            // ここまでで検索は終了。

            // 検索されたWordに対して、そのWordを持っているSentenceをたどり、
            // 文内容をKwicに変換・出力する
            int n = 0;
            m_Progress.SetRange(totalCount);
            foreach (Word word in queryResult)
            {
                int position = word.Pos;   // KWICのcenter wordとなる語の位置
                Sentence sen = word.Sen;
                KwicItem ki = new KwicItem(c, sen.ID, sen.StartChar, sen.EndChar);
                int pos = 0;
                foreach (Word w in sen.Words)
                {
                    Lexeme lex = w.Lex;
                    if (pos < position)
                    {
                        ki.Left.AddLexeme(lex, 0);
                    }
                    else if (pos == position)
                    {
                        ki.Center.AddLexeme(lex, KwicWord.KWA_PIVOT);
                    }
                    else
                    {
                        ki.Right.AddLexeme(lex, 0);
                    }
                    pos++;
                }
                m_Model.AddKwicItem(ki);
                m_Progress.Increment();
                n++;
            }
        }

        private LexemeResultSet QueryBunsetsuLexemeResultSet(DepSearchCondition dcond)
        {
            LexemeResultSet res = this.QueryLexemeResultSet(dcond.GetLexemeCondList(), false);
            // 一列に並べられたLexeme検索結果それぞれに対して、その所属する文節Noをセットする。
            int segno = 0;
            int lexno = 0;
            foreach (TagSearchCondition tcond in dcond.BunsetsuConds)
            {
                foreach (LexemeCondition lcond in tcond.LexemeConds)
                {
                    res.GetResult(lexno).BunsetsuNo = segno;
                    lexno++;
                }
                segno++;
            }

            return res;
        }
    }
}
