﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Corpora;
using NHibernate;
using ChaKi.Service.Database;
using System.Collections;

namespace ChaKi.Service.Search
{
    public class SentenceContextService : IServiceCommand
    {
        private Corpus m_Corpus;
        private int m_SenNo;
        private int m_Count;  // 前後に取得する文の数(-m_Count ～ +m_Count)
        private SentenceContext m_Result;

        public SentenceContextService(Corpus cps, int senNo, int count, SentenceContext result)
        {
            m_Corpus = cps;
            m_SenNo = senNo;
            m_Count = count;
            m_Result = result;

            // 結果を消去
            m_Result.Clear();
        }

        public void Begin()
        {
            lock (m_Corpus)
            {
                // Corpus(DB)の種類に合わせてConfigurationをセットアップする
                DBService dbs = DBService.Create(m_Corpus.DBParam);
                NHibernate.Cfg.Configuration cfg = dbs.GetConnection();
                using (ISessionFactory factory = cfg.BuildSessionFactory())
                {
                    // Sentence Listのクエリを生成する
                    string qstr = QueryBuilder.Instance.BuildSentenceContextQuery(m_SenNo, m_Count);
                    ISession session = null;
                    IList queryResult;
                    try
                    {
                        session = factory.OpenSession();
                        IQuery query = session.CreateQuery(qstr);
                        queryResult = query.List();
                        // ここまでで検索は終了。

                        // 検索結果(=文脈を構成する文集合)に対して、各文をSentenceContextに変換・出力する
                        foreach (Sentence sen in queryResult)
                        {
                            string text = sen.GetText();
                            if (sen.ID < m_SenNo)
                            {
                                m_Result.Pre.Add(text);
                            }
                            else if (sen.ID == m_SenNo)
                            {
                                m_Result.Center.Add(text);
                            }
                            else
                            {
                                m_Result.Post.Add(text);
                            }
                        }
                    }
                    finally
                    {
                        if (session != null)
                        {
                            session.Close();
                        }
                    }
                }
            }
        }
    }
}
