﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Kwic;
using ChaKi.Entity.Search;
using ChaKi.Entity.Corpora;
using NHibernate;
using System.Collections;
using System.Text.RegularExpressions;

namespace ChaKi.Service.Search
{
    public class StringSearchService : SearchServiceBase
    {

        private KwicList m_Model;

        public StringSearchService(KwicList model, SearchConditionsSequence condSeq, CommandProgress progress)
            : base(condSeq, progress)
        {
            m_Model = model;
        }

        /// <summary>
        /// コーパスごとのStringSearch本体
        /// StringSearchは検索方法が特殊で、まずCorpusに属するDocumentのTextを正規表現検索して、
        /// Document内の出現位置Offsetを得る。（この部分はSuffixArray等に置き換え可能なので、メソッドを分離している）
        /// その後、見つかった位置からSentenceをQueryにより得て結果とする。
        /// </summary>
        /// <param name="c"></param>
        protected override void ExecuteSearchSession(Corpus c)
        {
            SearchConditions cond = m_CondSeq.Last;  //TODO: 絞り込み等ではCondSeqを順次検索しなければならない

            IList lst = m_Session.CreateCriteria(typeof(DocumentSet)).List();
            if (lst.Count == 1)
            {
                c.DocumentSet = (DocumentSet)lst[0];
            }
            else
            {
                throw new Exception("Corpus:DocumentSet is not 1:1");
            }

            foreach (Document doc in c.DocumentSet.Documents)
            {
                string text = doc.Text;
                List<CharRange> rangeList = StringMatch(text, cond.StringCond);
                foreach (CharRange range in rangeList)
                {
                    string qstr = string.Format("from Sentence s where s.StartChar <= {0} and s.EndChar > {0}", range.Start.CharID);
                    IQuery query = m_Session.CreateQuery(qstr);
                    IList queryResult = query.List();
                    foreach (object o in queryResult)
                    {
                        Sentence sen = (Sentence)o;
                        KwicItem ki = new KwicItem(c, sen.ID, sen.StartChar, sen.EndChar);
                        ki.Left.AddText(text.Substring(sen.StartChar, range.Start.CharID-sen.StartChar), 0);
                        ki.Center.AddText(text.Substring(range.Start.CharID, range.Length), KwicWord.KWA_PIVOT);
                        ki.Right.AddText(text.Substring(range.End.CharID, sen.EndChar-range.End.CharID), 0);
                        m_Model.AddKwicItem(ki);
                    }
                }
            }
        }

        private List<CharRange> StringMatch(string text, StringSearchCondition cond)
        {
            List<CharRange> result = new List<CharRange>();

            Regex regex = new Regex(cond.Pattern);
            Match m = regex.Match( text );
            while (m.Success)
            {
                result.Add(new CharRange(new CharPos(m.Index, -1, -1), new CharPos(m.Index + m.Length, -1, -1)));
                m = m.NextMatch();
            }
 
            return result;
        }
    }
}
