﻿using ChaKi.Entity.Search;
using NHibernate;
using ChaKi.Entity.Kwic;
using ChaKi.Entity.Corpora;
using System.Collections;

namespace ChaKi.Service.Search
{
    public class WordListService : SearchServiceBase
    {
        private LexemeCountList m_Model;
        private LexemeResultSet m_LexemeResultSet;  //中間結果としてのLexemeリストのリスト

        public WordListService(LexemeCountList model, SearchConditionsSequence condSeq, CommandProgress progress)
            : base(condSeq, progress)
        {
            m_Model = model;
            m_LexemeResultSet = null;
        }

        protected override void ExecuteSearchSession(Corpus c)
        {
            SearchConditions cond = m_CondSeq.Last; // WordListは当面、単一検索のみ扱う

            // Lexemeの検索条件文(HQL)を作成し、検索結果を得る
            m_LexemeResultSet = QueryLexemeResultSet(m_CondSeq.Last.TagCond.LexemeConds, true);
            if (m_LexemeResultSet == null || m_LexemeResultSet.Count == 0)
            {
                m_Progress.SetRange(0);     // ヒットなし
                return;
            }

            // Wordの検索条件文(HQL)を作成し、検索を実行する。
            string qstr = QueryBuilder.Instance.BuildWordListQuery(m_LexemeResultSet, cond);
            IQuery query = m_Session.CreateQuery(qstr);
            IList queryResult = query.List();
            int totalCount = queryResult.Count;

            // ここまでで検索は終了。

            // 検索されたWordに対して、そのWordを持っているSentenceをたどり、
            // 文内容をKwicに変換・出力する
            int n = 0;
            m_Progress.SetRange(totalCount);
            foreach (object[] result in queryResult)
            {
                Lexeme lex = (Lexeme)result[0];
                long count = (long)result[1];
                m_Model.Add(lex, c, (int)count);
                m_Progress.Increment();
                n++;
            }
        }
    }
}
