/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.util;

import charactermanaj.model.util.StartupSupportForDocBasedData;
import charactermanaj.util.UserDataFactory;
import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class PurgeUnusedCache
extends StartupSupportForDocBasedData {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    PurgeUnusedCache() {
    }

    public void doStartup() {
        UserDataFactory userDataFactory = UserDataFactory.getInstance();
        File cacheDir = userDataFactory.getSpecialDataDir("*.ser");
        this.getDocBaseMapInCaches(StartupSupportForDocBasedData.DocBaseSignatureStoratage.NEW_FORMAT);
        String[] suffixes = new String[]{"-character.xml-cache.ser", "-workingset.ser", "-favorites.ser"};
        Map<String, URI> mangledURIMap = userDataFactory.getMangledNameMap(cacheDir);
        for (String suffix : suffixes) {
            Map<String, File> caches = this.getUUIDMangledNamedMap(cacheDir, suffix);
            for (Map.Entry<String, File> cacheEntry : caches.entrySet()) {
                String mangledUUID = cacheEntry.getKey();
                File cacheFile = cacheEntry.getValue();
                try {
                    File characterXmlFile;
                    URI uri = mangledURIMap.get(mangledUUID);
                    boolean remove = true;
                    if (uri != null && ((characterXmlFile = new File(uri)).exists() || characterXmlFile.isFile())) {
                        remove = false;
                    }
                    if (!remove) continue;
                    boolean result = cacheFile.delete();
                    this.logger.log(Level.INFO, "purge unused cache: " + cacheFile + "/succeeded=" + result);
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, "remove file failed. " + cacheFile, ex);
                }
            }
        }
    }
}

