/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.colormodel;

import charactermanaj.graphics.colormodel.ColorModel;

public class HSYColorModel
implements ColorModel {
    private static final float IR = 0.298912f;
    private static final float IG = 0.586611f;
    private static final float IB = 0.114478f;
    private static final String[] ITEM_TITLES = new String[]{"colorModel.HSY.hue", "colorModel.HSY.saturation", "colorModel.HSY.luminance"};

    public String getTitle() {
        return "colorModel.HSY.title";
    }

    public String getItemTitle(int index) {
        return ITEM_TITLES[index];
    }

    public static int getGrayscale(int r, int g, int b) {
        return (int)(0.298912f * (float)r + 0.586611f * (float)g + 0.114478f * (float)b) & 0xFF;
    }

    public float[] RGBtoHSV(int r, int g, int b, float[] hsyVals) {
        float hue;
        if (hsyVals == null || hsyVals.length < 3) {
            throw new IllegalArgumentException();
        }
        int max = Math.max(Math.max(r, g), b);
        int min = Math.min(Math.min(r, g), b);
        float saturation = (float)(max - min) / 255.0f;
        float rr = (float)r / 255.0f;
        float gg = (float)g / 255.0f;
        float bb = (float)b / 255.0f;
        float lum = 0.298912f * rr + 0.586611f * gg + 0.114478f * bb;
        if (lum > 1.0f) {
            lum = 1.0f;
        }
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            hue = max == r ? (gg - bb) / saturation * 60.0f : (max == g ? (bb - rr) / saturation * 60.0f + 120.0f : (rr - gg) / saturation * 60.0f + 240.0f);
            if (hue < 0.0f) {
                hue += 360.0f;
            }
            hue /= 360.0f;
        }
        hsyVals[0] = hue;
        hsyVals[1] = saturation;
        hsyVals[2] = lum;
        return hsyVals;
    }

    public int HSVtoRGB(float hue, float sat, float lum) {
        float t;
        float b;
        float g;
        float r;
        float h;
        hue -= (float)Math.floor(hue);
        if (sat < 0.0f) {
            sat = 0.0f;
        } else if (sat > 1.0f) {
            sat = 1.0f;
        }
        if (lum < 0.0f) {
            lum = 0.0f;
        } else if (lum > 1.0f) {
            lum = 1.0f;
        }
        if (hue <= 0.16666667f) {
            h = hue * 6.0f;
            r = 0.701088f - 0.586611f * h;
            g = -0.298912f + 0.41338903f * h;
            b = -0.298912f - 0.586611f * h;
        } else if (hue <= 0.5f) {
            h = (hue - 0.33333334f) * 6.0f;
            if (hue > 0.33333334f) {
                r = -0.586611f - 0.114478f * h;
                g = 0.41338903f - 0.114478f * h;
                b = -0.586611f + 0.885522f * h;
            } else {
                r = -0.586611f + -0.701088f * h;
                g = 0.41338903f + 0.298912f * h;
                b = -0.586611f + 0.298912f * h;
            }
        } else if (hue <= 0.8333333f) {
            h = (hue - 0.6666667f) * 6.0f;
            if (hue > 0.6666667f) {
                r = -0.114478f + 0.701088f * h;
                g = -0.114478f - 0.298912f * h;
                b = 0.885522f - 0.298912f * h;
            } else {
                r = -0.114478f + 0.586611f * h;
                g = -0.114478f + -0.41338903f * h;
                b = 0.885522f + 0.586611f * h;
            }
        } else {
            h = (hue - 1.0f) * 6.0f;
            r = 0.701088f + 0.114478f * h;
            g = -0.298912f + 0.114478f * h;
            b = -0.298912f + -0.885522f * h;
        }
        float ma = Math.max(r *= sat, Math.max(g *= sat, b *= sat));
        float mi = Math.min(r, Math.min(g, b));
        float x = 1.0f;
        if (ma + lum > 1.0f) {
            x = t = (1.0f - lum) / ma;
        }
        if (mi + lum < 0.0f && (t = lum / -mi) < x) {
            x = t;
        }
        int red = (int)((lum + r * x) * 255.0f) & 0xFF;
        int green = (int)((lum + g * x) * 255.0f) & 0xFF;
        int blue = (int)((lum + b * x) * 255.0f) & 0xFF;
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }
}

