/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.ui.ArchiveFileDialog;
import charactermanaj.ui.ImportWizardCardPanel;
import charactermanaj.ui.ImportWizardDialog;
import charactermanaj.ui.progress.ProgressHandle;
import charactermanaj.ui.progress.Worker;
import charactermanaj.ui.progress.WorkerException;
import charactermanaj.ui.progress.WorkerWithProgessDialog;
import charactermanaj.ui.util.FileDropTarget;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportFileSelectPanel
extends ImportWizardCardPanel {
    private static final long serialVersionUID = 1L;
    public static final String PANEL_NAME = "fileSelectPanel";
    private static ArchiveFileDialog archiveFileDialog = new ArchiveFileDialog();
    private ImportWizardDialog parent;
    private JRadioButton radioArchiveFile;
    private JTextField txtArchiveFile;
    private Action actChooseFile;
    private JRadioButton radioDirectory;
    private JTextField txtDirectory;
    private Action actChooseDirectory;

    public ImportFileSelectPanel() {
        this.setLayout(new BorderLayout());
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("languages/importwizdialog");
        DocumentListener documentListener = new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                this.fireEvent();
            }

            public void insertUpdate(DocumentEvent e) {
                this.fireEvent();
            }

            public void changedUpdate(DocumentEvent e) {
                this.fireEvent();
            }

            protected void fireEvent() {
                ImportFileSelectPanel.this.fireChangeEvent();
            }
        };
        this.txtArchiveFile = new JTextField();
        this.txtDirectory = new JTextField();
        this.txtArchiveFile.getDocument().addDocumentListener(documentListener);
        this.txtDirectory.getDocument().addDocumentListener(documentListener);
        this.actChooseFile = new AbstractAction(strings.getProperty("browse")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ImportFileSelectPanel.this.onChooseFile();
            }
        };
        this.actChooseDirectory = new AbstractAction(strings.getProperty("browse")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ImportFileSelectPanel.this.onChooseDirectory();
            }
        };
        JPanel fileChoosePanel = new JPanel();
        GridBagLayout fileChoosePanelLayout = new GridBagLayout();
        fileChoosePanel.setLayout(fileChoosePanelLayout);
        this.radioArchiveFile = new JRadioButton(strings.getProperty("importingArchiveFile"));
        this.radioDirectory = new JRadioButton(strings.getProperty("importingDirectory"));
        ChangeListener radioChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ImportFileSelectPanel.this.updateUIState();
                ImportFileSelectPanel.this.fireChangeEvent();
            }
        };
        this.radioArchiveFile.addChangeListener(radioChangeListener);
        this.radioDirectory.addChangeListener(radioChangeListener);
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.radioArchiveFile);
        btnGroup.add(this.radioDirectory);
        this.radioArchiveFile.setSelected(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 3;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 17;
        gbc.fill = 1;
        fileChoosePanel.add((Component)this.radioArchiveFile, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.ipadx = 45;
        gbc.weightx = 0.0;
        fileChoosePanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.ipadx = 0;
        gbc.weightx = 1.0;
        fileChoosePanel.add((Component)this.txtArchiveFile, gbc);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.ipadx = 0;
        gbc.weightx = 0.0;
        fileChoosePanel.add((Component)new JButton(this.actChooseFile), gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.ipadx = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        fileChoosePanel.add((Component)this.radioDirectory, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.ipadx = 45;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        fileChoosePanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.ipadx = 0;
        gbc.weightx = 1.0;
        fileChoosePanel.add((Component)this.txtDirectory, gbc);
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.ipadx = 0;
        gbc.weightx = 0.0;
        fileChoosePanel.add((Component)new JButton(this.actChooseDirectory), gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.ipadx = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        fileChoosePanel.add(Box.createGlue(), gbc);
        this.add((Component)fileChoosePanel, "Center");
        new DropTarget(this, new FileDropTarget(){

            @Override
            protected void onDropFiles(List<File> dropFiles) {
                if (dropFiles == null || dropFiles.isEmpty()) {
                    return;
                }
                ImportFileSelectPanel.this.setSelectFile(dropFiles);
            }

            @Override
            protected void onException(Exception ex) {
                ErrorMessageHelper.showErrorDialog(ImportFileSelectPanel.this, ex);
            }
        });
        this.updateUIState();
    }

    public void setSelectFile(List<File> dropFiles) {
        File dropFile = null;
        if (dropFiles != null && dropFiles.size() > 0) {
            dropFile = dropFiles.get(0);
        }
        if (dropFile == null) {
            this.txtDirectory.setText("");
            this.txtArchiveFile.setText("");
            this.radioDirectory.setSelected(false);
            this.radioArchiveFile.setSelected(false);
        } else if (dropFile.isDirectory()) {
            this.txtDirectory.setText(dropFile.getPath());
            this.radioDirectory.setSelected(true);
        } else if (dropFile.isFile()) {
            this.txtArchiveFile.setText(dropFile.getPath());
            this.radioArchiveFile.setSelected(true);
        }
    }

    protected void updateUIState() {
        boolean enableArchiveFile = this.radioArchiveFile.isSelected();
        boolean enableDirectory = this.radioDirectory.isSelected();
        this.txtArchiveFile.setEnabled(enableArchiveFile);
        this.actChooseFile.setEnabled(enableArchiveFile);
        this.txtDirectory.setEnabled(enableDirectory);
        this.actChooseDirectory.setEnabled(enableDirectory);
    }

    protected void onChooseFile() {
        File file;
        File initFile = null;
        if (this.txtArchiveFile.getText().trim().length() > 0) {
            initFile = new File(this.txtArchiveFile.getText());
        }
        if ((file = archiveFileDialog.showOpenDialog(this, initFile)) != null) {
            this.txtArchiveFile.setText(file.getPath());
            this.fireChangeEvent();
        }
    }

    protected void onChooseDirectory() {
        String directoryTxt = this.txtDirectory.getText();
        JFileChooser dirChooser = new JFileChooser(directoryTxt);
        dirChooser.setFileSelectionMode(1);
        if (dirChooser.showOpenDialog(this) != 0) {
            return;
        }
        File dir = dirChooser.getSelectedFile();
        if (dir != null) {
            this.txtDirectory.setText(dir.getPath());
            this.fireChangeEvent();
        }
    }

    @Override
    public boolean isReadyNext() {
        String directoryTxt;
        String fileTxt;
        return this.radioArchiveFile.isSelected() ? (fileTxt = this.txtArchiveFile.getText()) != null && fileTxt.trim().length() > 0 : this.radioDirectory.isSelected() && (directoryTxt = this.txtDirectory.getText()) != null && directoryTxt.trim().length() > 0;
    }

    @Override
    public void onActive(ImportWizardDialog parent, ImportWizardCardPanel previousPanel) {
        this.parent = parent;
        this.closeArchive();
    }

    public void closeArchive() {
        try {
            this.parent.importModel.closeImportSource();
        }
        catch (IOException ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    @Override
    public String doNext() {
        URI importArchive;
        File file;
        if (!this.isReadyNext()) {
            return null;
        }
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("languages/importwizdialog");
        if (this.radioArchiveFile.isSelected()) {
            file = new File(this.txtArchiveFile.getText());
            if (!file.exists() || !file.isFile()) {
                JOptionPane.showMessageDialog(this, strings.getProperty("fileNotFound"), "ERROR", 0);
                return null;
            }
            importArchive = file.toURI();
        } else if (this.radioDirectory.isSelected()) {
            file = new File(this.txtDirectory.getText());
            if (!file.exists() || !file.isDirectory()) {
                JOptionPane.showMessageDialog(this, strings.getProperty("directoryNotFound"), "ERROR", 0);
                return null;
            }
            importArchive = file.toURI();
        } else {
            return null;
        }
        try {
            this.parent.importModel.openImportSource(importArchive, this.parent.current);
            Worker<Object> worker = new Worker<Object>(){

                @Override
                public Void doWork(ProgressHandle progressHandle) throws IOException {
                    ((ImportFileSelectPanel)ImportFileSelectPanel.this).parent.importModel.loadContents(progressHandle);
                    return null;
                }
            };
            WorkerWithProgessDialog<Object> dlg = new WorkerWithProgessDialog<Object>(this.parent, worker);
            dlg.startAndWait();
            return "importTypeSelectPanel";
        }
        catch (WorkerException ex) {
            ErrorMessageHelper.showErrorDialog(this, ex.getCause());
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
        return null;
    }
}

