/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingSet
implements Serializable {
    private static final Logger logger = Logger.getLogger(WorkingSet.class.getName());
    private static final long serialVersionUID = -4728766140876842242L;
    private Map<PartsIdentifier, PartsColorInfo> partsColorInfoMap;
    private String characterDataRev;
    private PartsSet partsSet;
    private URI characterDocBase;
    private File lastUsedSaveDir;
    private File lastUsedExportDir;
    private PartsSet lastUsePresetParts;
    private CharacterData characterData;

    private void readObject(ObjectInputStream inp) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = inp.readFields();
        ObjectStreamClass sig = fields.getObjectStreamClass();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "WorkingSet\u306e\u30c7\u30b7\u30ea\u30a2\u30e9\u30a4\u30ba name=" + sig.getName() + "/sid=" + sig.getSerialVersionUID());
        }
        this.partsColorInfoMap = (Map)fields.get("partsColorInfoMap", null);
        this.characterDataRev = (String)fields.get("characterDataRev", null);
        this.partsSet = (PartsSet)fields.get("partsSet", null);
        Object anyDocBase = fields.get("characterDocBase", null);
        if (anyDocBase != null && anyDocBase instanceof URL) {
            File file = new File(((URL)anyDocBase).getPath());
            anyDocBase = file.toURI();
        }
        this.characterDocBase = (URI)anyDocBase;
        this.lastUsedSaveDir = (File)fields.get("lastUsedSaveDir", null);
        this.lastUsedExportDir = (File)fields.get("lastUsedExportDir", null);
        if (sig.getField("lastUsePresetParts") != null) {
            this.lastUsePresetParts = (PartsSet)fields.get("lastUsePresetParts", null);
        }
        if (sig.getField("characterData") != null) {
            this.characterData = (CharacterData)fields.get("characterData", null);
        }
    }

    public void setCharacterDataRev(String characterDataRev) {
        this.characterDataRev = characterDataRev;
    }

    public String getCharacterDataRev() {
        return this.characterDataRev;
    }

    public Map<PartsIdentifier, PartsColorInfo> getPartsColorInfoMap() {
        return this.partsColorInfoMap;
    }

    public void setPartsColorInfoMap(Map<PartsIdentifier, PartsColorInfo> partsColorInfoMap) {
        this.partsColorInfoMap = partsColorInfoMap;
    }

    public void setCharacterDocBase(URI characterDocBase) {
        this.characterDocBase = characterDocBase;
    }

    public void setPartsSet(PartsSet partsSet) {
        this.partsSet = partsSet;
    }

    public URI getCharacterDocBase() {
        return this.characterDocBase;
    }

    public PartsSet getPartsSet() {
        return this.partsSet;
    }

    public void setLastUsedSaveDir(File lastUsedSaveDir) {
        this.lastUsedSaveDir = lastUsedSaveDir;
    }

    public void setLastUsedExportDir(File lastUsedExportDir) {
        this.lastUsedExportDir = lastUsedExportDir;
    }

    public File getLastUsedSaveDir() {
        return this.lastUsedSaveDir;
    }

    public File getLastUsedExportDir() {
        return this.lastUsedExportDir;
    }

    public PartsSet getLastUsePresetParts() {
        return this.lastUsePresetParts;
    }

    public void setLastUsePresetParts(PartsSet lastUsePresetParts) {
        this.lastUsePresetParts = lastUsePresetParts;
    }

    public void setCharacterData(CharacterData characterData) {
        this.characterData = characterData;
    }

    public CharacterData getCharacterData() {
        return this.characterData;
    }

    public String toString() {
        return "docBase:" + this.characterDocBase + "/rev:" + this.characterDataRev;
    }
}

