/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ConfigurationDirUtilities;
import charactermanaj.util.SetupLocalization;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractList;
import java.util.Arrays;

public abstract class ResourceLoader {
    protected ClassLoader getClassLoader() {
        return this.getLocalizedClassLoader(this.getDefaultClassLoader());
    }

    protected ClassLoader getDefaultClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = ResourceLoader.class.getClassLoader();
                }
                return cl;
            }
        });
    }

    protected ClassLoader getLocalizedClassLoader(ClassLoader parent) {
        try {
            File baseDir = ConfigurationDirUtilities.getUserDataDir();
            SetupLocalization localize = new SetupLocalization(baseDir);
            File resourceDir = localize.getResourceDir();
            if (!resourceDir.exists() || !resourceDir.isDirectory()) {
                return parent;
            }
            URLClassLoader cl = new URLClassLoader(new URL[]{resourceDir.toURI().toURL()}, parent){

                public URL getResource(String name) {
                    ClassLoader parent;
                    URL url = this.findResource(name);
                    if (url == null && (parent = this.getParent()) != null) {
                        url = parent.getResource(name);
                    }
                    return url;
                }
            };
            return cl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected URL getResource(String name) {
        if (name == null) {
            return null;
        }
        return this.getClassLoader().getResource(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ResourceNames
    extends AbstractList<String> {
        private final String[] resourceNames;

        ResourceNames(String[] resourceNames) {
            if (resourceNames == null) {
                throw new IllegalArgumentException();
            }
            this.resourceNames = resourceNames;
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.resourceNames);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj instanceof ResourceNames) {
                ResourceNames o = (ResourceNames)obj;
                return Arrays.equals(this.resourceNames, o.resourceNames);
            }
            return false;
        }

        @Override
        public int size() {
            return this.resourceNames.length;
        }

        @Override
        public String get(int index) {
            return this.resourceNames[index];
        }
    }
}

