/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj;

import charactermanaj.model.AppConfig;
import charactermanaj.model.util.StartupSupport;
import charactermanaj.ui.MainFrame;
import charactermanaj.ui.ProfileListManager;
import charactermanaj.util.ApplicationLoggerConfigurator;
import charactermanaj.util.ErrorMessageHelper;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;

public final class Main {
    private static Logger logger;
    private static final boolean isMacOSX;

    public static void main(String[] args) {
        try {
            if (Main.isMacOSX()) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", "CharacterManaJ");
            }
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            AppConfig appConfig = AppConfig.getInstance();
            appConfig.loadConfig();
            StartupSupport.getInstance().doStartup();
            MainFrame mainFrame = ProfileListManager.openDefaultProfile();
            if (Main.isMacOSX()) {
                Class<?> clz = Class.forName("charactermanaj.ui.MainFramePartialForMacOSX");
                Method mtd = clz.getMethod("setupScreenMenu", MainFrame.class);
                mtd.invoke(null, mainFrame);
            }
            mainFrame.showMainFrame();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            if (logger != null) {
                logger.log(Level.SEVERE, "Application initiation failed.", ex);
            }
            ErrorMessageHelper.showErrorDialog(null, ex);
            MainFrame.closeAllProfiles();
        }
    }

    public static boolean isMacOSX() {
        return isMacOSX;
    }

    static {
        String lcOS = System.getProperty("os.name").toLowerCase();
        isMacOSX = lcOS.startsWith("mac os x");
        try {
            ApplicationLoggerConfigurator.configure();
            logger = Logger.getLogger(Main.class.getName());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            logger = null;
        }
        if (logger != null) {
            logger.log(Level.INFO, "os.name=" + lcOS + "/isMacOSX=" + isMacOSX);
        }
    }
}

