/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.ui.UkagakaConvertDialog;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class UkagakaImageSaveHelper {
    private static final Logger logger = Logger.getLogger(UkagakaImageSaveHelper.class.getName());
    protected static final String STRINGS_RESOURCE = "languages/ukagakaImageSaveHelper";
    protected static final FileFilter pngFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".png");
        }

        public String getDescription() {
            return "PNG(*.png)";
        }
    };
    protected File lastUseOpenDir;
    protected File lastUseSaveDir;
    protected String lastUseSaveName = "surface";
    protected Color transparentColorKey;
    protected boolean autoTransparentColor = true;

    public UkagakaImageSaveHelper() {
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.lastUseSaveName = strings.getProperty("default.lastUseSaveName");
    }

    protected JFileChooser createFileChooser(final boolean save) {
        JFileChooser fileChooser = new JFileChooser(){
            private static final long serialVersionUID = 1L;

            public void approveSelection() {
                Properties strings;
                File outFile = this.getSelectedFile();
                if (outFile == null) {
                    return;
                }
                String lcName = outFile.getName().toLowerCase();
                FileFilter selfilter = this.getFileFilter();
                if (selfilter == pngFilter && !lcName.endsWith(".png")) {
                    outFile = new File(outFile.getPath() + ".png");
                    this.setSelectedFile(outFile);
                }
                if (save && outFile.exists() && JOptionPane.showConfirmDialog(this, (strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(UkagakaImageSaveHelper.STRINGS_RESOURCE)).getProperty("confirmOverwrite"), strings.getProperty("confirm"), 0, 2) != 0) {
                    return;
                }
                super.approveSelection();
            }
        };
        if (this.lastUseSaveDir != null) {
            fileChooser.setCurrentDirectory(this.lastUseSaveDir);
        }
        fileChooser.setFileFilter(pngFilter);
        if (!save) {
            fileChooser.setAcceptAllFileFilterUsed(false);
        }
        fileChooser.addChoosableFileFilter(pngFilter);
        return fileChooser;
    }

    public void save(JFrame parent, BufferedImage img, Color colorKey) throws IOException {
        final UkagakaConvertDialog dlg = new UkagakaConvertDialog(parent);
        if (!this.autoTransparentColor && this.transparentColorKey != null) {
            colorKey = this.transparentColorKey;
        }
        dlg.setExportImage(img, colorKey);
        dlg.setAutoTransparentColor(this.autoTransparentColor);
        dlg.setSaveActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = UkagakaImageSaveHelper.this.createFileChooser(true);
                fileChooser.setSelectedFile(new File(UkagakaImageSaveHelper.this.lastUseSaveDir, UkagakaImageSaveHelper.this.lastUseSaveName));
                int ret = fileChooser.showSaveDialog(dlg);
                if (ret != 0) {
                    return;
                }
                dlg.setResult(fileChooser.getSelectedFile());
                dlg.dispose();
            }
        });
        dlg.setVisible(true);
        File selectedFile = (File)dlg.getResult();
        if (selectedFile == null) {
            return;
        }
        this.lastUseSaveName = selectedFile.getName();
        this.lastUseSaveDir = selectedFile.getParentFile();
        File pngFile = selectedFile;
        File pnaFile = this.makePNAFileName(pngFile);
        File[] outfiles = new File[]{pngFile, pnaFile};
        BufferedImage[] outimages = new BufferedImage[]{dlg.getOpaqueImage(), dlg.getAlphaImage()};
        this.savePNGImages(outfiles, outimages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void savePNGImages(File[] outfiles, BufferedImage[] outimages) throws IOException {
        if (outfiles == null || outimages == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306bnull\u306f\u6307\u5b9a\u3067\u307e\u304d\u305b\u3093\u3002");
        }
        if (outfiles.length != outimages.length) {
            throw new IllegalArgumentException("\u30d5\u30a1\u30a4\u30eb\u304a\u3088\u3073\u30a4\u30e1\u30fc\u30b8\u306e\u500b\u6570\u306f\u4e00\u81f4\u3057\u3066\u3044\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093.");
        }
        ImageWriter iw = ImageIO.getImageWritersByFormatName("png").next();
        try {
            iw.addIIOWriteWarningListener(new IIOWriteWarningListener(){

                public void warningOccurred(ImageWriter source, int imageIndex, String warning) {
                    logger.log(Level.WARNING, warning);
                }
            });
            for (int idx = 0; idx < outfiles.length; ++idx) {
                File outfile = outfiles[idx];
                BufferedImage outimage = outimages[idx];
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outfile));
                try {
                    ImageWriteParam iwp = iw.getDefaultWriteParam();
                    IIOImage ioimg = new IIOImage(outimage, null, null);
                    ImageOutputStream imgstm = ImageIO.createImageOutputStream(bos);
                    try {
                        iw.setOutput(imgstm);
                        iw.write(null, ioimg, iwp);
                        continue;
                    }
                    finally {
                        imgstm.close();
                    }
                }
                finally {
                    bos.close();
                }
            }
        }
        finally {
            iw.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertChooseFiles(JFrame parent, Color colorKey) throws IOException {
        JFileChooser fileChooser = this.createFileChooser(false);
        fileChooser.setCurrentDirectory(this.lastUseOpenDir);
        fileChooser.setMultiSelectionEnabled(true);
        int ret = fileChooser.showOpenDialog(parent);
        if (ret != 0) {
            return;
        }
        File[] files = fileChooser.getSelectedFiles();
        if (files == null || files.length == 0) {
            return;
        }
        this.lastUseOpenDir = files[0].getParentFile();
        final UkagakaConvertDialog dlg = new UkagakaConvertDialog(parent, null, true);
        if (!this.autoTransparentColor && this.transparentColorKey != null) {
            colorKey = this.transparentColorKey;
        }
        dlg.setAutoTransparentColor(this.autoTransparentColor);
        ImageReader ir = ImageIO.getImageReadersByFormatName("png").next();
        try {
            for (final File file : files) {
                BufferedImage img;
                String fname = file.getName();
                ImageReadParam param = ir.getDefaultReadParam();
                ImageInputStream iis = ImageIO.createImageInputStream(file);
                try {
                    ir.setInput(iis);
                    img = ir.read(0, param);
                }
                finally {
                    iis.close();
                }
                img = this.convertIntARGB(img);
                dlg.setCaption(fname);
                dlg.setExportImage(img, colorKey);
                dlg.setSaveActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (!dlg.isOverwriteOriginalFile()) {
                            JFileChooser fileChooser = UkagakaImageSaveHelper.this.createFileChooser(true);
                            fileChooser.setCurrentDirectory(file.getParentFile());
                            fileChooser.setSelectedFile(file);
                            int ret = fileChooser.showSaveDialog(dlg);
                            if (ret != 0) {
                                return;
                            }
                            dlg.setResult(fileChooser.getSelectedFile());
                        } else {
                            dlg.setResult(file);
                        }
                        dlg.dispose();
                    }
                });
                dlg.setVisible(true);
                File selectedFile = (File)dlg.getResult();
                if (selectedFile == null) {
                    break;
                }
                File pngFile = selectedFile;
                File pnaFile = this.makePNAFileName(pngFile);
                File[] outfiles = new File[]{pngFile, pnaFile};
                BufferedImage[] outimages = new BufferedImage[]{dlg.getOpaqueImage(), dlg.getAlphaImage()};
                this.savePNGImages(outfiles, outimages);
            }
        }
        finally {
            ir.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage convertIntARGB(BufferedImage img) {
        if (img == null || img.getType() == 2) {
            return img;
        }
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage dst = new BufferedImage(w, h, 2);
        Graphics2D g = dst.createGraphics();
        try {
            g.drawImage(img, 0, 0, w, h, 0, 0, w, h, null);
        }
        finally {
            g.dispose();
        }
        return dst;
    }

    protected File makePNAFileName(File pngFile) {
        if (pngFile == null) {
            return null;
        }
        String fname = pngFile.getName();
        int extpos = fname.lastIndexOf(46);
        if (extpos >= 0) {
            fname = fname.substring(0, extpos);
        }
        fname = fname + ".pna";
        return new File(pngFile.getParent(), fname);
    }
}

