/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecentData
implements Serializable {
    private static final Logger logger = Logger.getLogger(RecentData.class.getName());
    private static final long serialVersionUID = 7232012934972862661L;
    private String appVersion;
    private URI docBase;

    private void readObject(ObjectInputStream inp) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = inp.readFields();
        ObjectStreamClass sig = fields.getObjectStreamClass();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "RecentData\u306e\u30c7\u30b7\u30ea\u30a2\u30e9\u30a4\u30ba name=" + sig.getName() + "/sid=" + sig.getSerialVersionUID());
        }
        this.appVersion = (String)fields.get("appVersion", null);
        Object anyDocBase = fields.get("docBase", null);
        if (anyDocBase != null && anyDocBase instanceof URL) {
            File file = new File(((URL)anyDocBase).getPath());
            anyDocBase = file.toURI();
        }
        this.docBase = (URI)anyDocBase;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public URI getDocBase() {
        return this.docBase;
    }

    public void setDocBase(URI docBase) {
        this.docBase = docBase;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("appVersion=" + this.appVersion + "/docBase=" + this.docBase);
        return buf.toString();
    }
}

