/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.util;

import charactermanaj.ui.util.FileDropListener;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDropTarget
extends DropTargetAdapter {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    protected FileDropListener fileDropListener;

    public FileDropTarget() {
        this(null);
    }

    public FileDropTarget(FileDropListener fileDropListener) {
        this.fileDropListener = fileDropListener;
    }

    public FileDropListener getFileDropListener() {
        return this.fileDropListener;
    }

    public void setFileDropListener(FileDropListener fileDropListener) {
        this.fileDropListener = fileDropListener;
    }

    protected void onDropFiles(List<File> dropFiles) {
        if (this.fileDropListener != null && !dropFiles.isEmpty()) {
            this.fileDropListener.onDropFiles(dropFiles);
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            DataFlavor uriListFlavor;
            try {
                uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
            }
            catch (ClassNotFoundException ex) {
                this.logger.log(Level.WARNING, "urlListFlavor is not supported.", ex);
                uriListFlavor = null;
            }
            ArrayList<File> dropFiles = new ArrayList<File>();
            block7: for (DataFlavor flavor : dtde.getCurrentDataFlavors()) {
                this.logger.log(Level.FINE, "flavor: " + flavor);
                if (DataFlavor.javaFileListFlavor.equals(flavor)) {
                    dtde.acceptDrop(1);
                    List files = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    this.logger.log(Level.FINER, "DragAndDrop files(javaFileListFlavor)=" + files);
                    dropFiles.addAll(files);
                    break;
                }
                if (uriListFlavor == null || !uriListFlavor.equals(flavor)) continue;
                dtde.acceptDrop(1);
                String uriList = (String)dtde.getTransferable().getTransferData(uriListFlavor);
                this.logger.log(Level.FINER, "DragAndDrop files(text/uri-list)=" + uriList);
                for (String fileStr : uriList.split("\r\n")) {
                    if ((fileStr = fileStr.trim()).startsWith("#")) continue;
                    try {
                        URI uri = new URI(fileStr);
                        File dropFile = new File(uri);
                        dropFiles.add(dropFile);
                        continue block7;
                    }
                    catch (URISyntaxException ex) {
                        this.logger.log(Level.WARNING, "invalid drop file: " + fileStr, ex);
                    }
                }
            }
            Iterator ite = dropFiles.iterator();
            while (ite.hasNext()) {
                File dropFile = (File)ite.next();
                if (dropFile != null && dropFile.exists()) continue;
                ite.remove();
            }
            this.onDropFiles(dropFiles);
        }
        catch (UnsupportedFlavorException ex) {
            this.logger.log(Level.WARNING, "unsipported flovaor.", ex);
            this.onException(ex);
        }
        catch (IOException ex) {
            this.logger.log(Level.WARNING, "drop target failed.", ex);
            this.onException(ex);
        }
    }

    protected void onException(Exception ex) {
    }
}

