/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.dev.HighRepJobPolicy;
import java.util.Map;
import java.util.Random;

public class DefaultHighRepJobPolicy
implements HighRepJobPolicy {
    public static final String RANDOM_SEED_PROPERTY = "datastore.default_high_rep_job_policy_random_seed";
    public static final String UNAPPLIED_JOB_PERCENTAGE_PROPERTY = "datastore.default_high_rep_job_policy_unapplied_job_pct";
    static final int RANDOM_CEILING = 10000;
    private static final int UNAPPLIED_JOB_PCT_MULTIPLIER = 100;
    final Random random;
    final int unappliedJobCutoff;

    public DefaultHighRepJobPolicy(long unappliedJobSeed, float unappliedJobPercentage) {
        this.random = new Random(unappliedJobSeed);
        if (unappliedJobPercentage < 0.0f) {
            throw new IllegalArgumentException(String.format("Unapplied job percentage must be >= 0 (received %f)", Float.valueOf(unappliedJobPercentage)));
        }
        if ((double)unappliedJobPercentage > 100.0) {
            throw new IllegalArgumentException(String.format("Unapplied job percentage must be <= 100.00 (received %f)", Float.valueOf(unappliedJobPercentage)));
        }
        this.unappliedJobCutoff = Float.valueOf(unappliedJobPercentage * 100.0f).intValue();
    }

    DefaultHighRepJobPolicy(Map<String, String> localDatastoreServiceProperties) {
        this(DefaultHighRepJobPolicy.getUnappliedJobSeedPropValue(localDatastoreServiceProperties), DefaultHighRepJobPolicy.getUnappliedJobPctPropValue(localDatastoreServiceProperties));
    }

    private static float getUnappliedJobPctPropValue(Map<String, String> localDatastoreServiceProperties) {
        String unappliedJobPctProp = localDatastoreServiceProperties.get(UNAPPLIED_JOB_PERCENTAGE_PROPERTY);
        if (unappliedJobPctProp != null) {
            return Float.valueOf(unappliedJobPctProp).floatValue();
        }
        return 0.0f;
    }

    static long getUnappliedJobSeedPropValue(Map<String, String> localDatastoreServiceProperties) {
        String unappliedJobSeedProp = localDatastoreServiceProperties.get(RANDOM_SEED_PROPERTY);
        if (unappliedJobSeedProp != null) {
            return Long.valueOf(unappliedJobSeedProp);
        }
        return System.currentTimeMillis();
    }

    private boolean shouldApply() {
        return this.nextRandomInt() >= this.unappliedJobCutoff;
    }

    @Override
    public boolean shouldApplyNewJob(Key entityGroup) {
        return this.shouldApply();
    }

    @Override
    public boolean shouldRollForwardExistingJob(Key entityGroup) {
        return this.shouldApply();
    }

    int nextRandomInt() {
        return this.random.nextInt(10000);
    }
}

