/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.ApplicationXml;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.InputStream;
import org.mortbay.xml.XmlParser;

public class ApplicationXmlReader {
    public ApplicationXml processXml(InputStream is) {
        ApplicationXml.Builder builder = ApplicationXml.builder();
        for (Object o : XmlUtils.parse(is)) {
            XmlParser.Node node;
            if (!(o instanceof XmlParser.Node) || "icon".equals((node = (XmlParser.Node)o).getTag()) || "display-name".equals(node.getTag()) || "description".equals(node.getTag())) continue;
            if ("module".equals(node.getTag())) {
                this.handleModuleNode(node, builder.getModulesBuilder());
                continue;
            }
            if ("security-role".equals(node.getTag()) || "library-directory".equals(node.getTag())) continue;
            this.reportUnrecognizedTag(node.getTag());
        }
        return builder.build();
    }

    private void handleModuleNode(XmlParser.Node module, ApplicationXml.Modules.Builder builder) {
        for (Object o : module) {
            XmlParser.Node node;
            if (!(o instanceof XmlParser.Node) || "alt-dd".equals((node = (XmlParser.Node)o).getTag()) || "connector".equals(node.getTag()) || "ejb".equals(node.getTag()) || "java".equals(node.getTag())) continue;
            if ("web".equals(node.getTag())) {
                this.handleWebNode(node, builder);
                continue;
            }
            this.reportUnrecognizedTag(node.getTag());
        }
    }

    private void handleWebNode(XmlParser.Node web, ApplicationXml.Modules.Builder builder) {
        String contextRoot = null;
        for (Object o : web) {
            XmlParser.Node node;
            if (!(o instanceof XmlParser.Node) || "web-uri".equals((node = (XmlParser.Node)o).getTag())) continue;
            if ("context-root".equals(node.getTag())) {
                if (contextRoot != null) {
                    throw new AppEngineConfigException("context-root multiply defined in application.xml web module.");
                }
                contextRoot = XmlUtils.getText(node);
                if (contextRoot.isEmpty()) {
                    throw new AppEngineConfigException("context-root empty in application.xml web module.");
                }
                builder.addWeb(new ApplicationXml.Modules.Web(contextRoot));
                continue;
            }
            this.reportUnrecognizedTag(node.getTag());
        }
        if (null == contextRoot) {
            throw new AppEngineConfigException("context-root not defined in application.xml web module.");
        }
    }

    private void reportUnrecognizedTag(String tag) throws AppEngineConfigException {
        throw new AppEngineConfigException("Unrecognized element <" + tag + "> in application.xml.");
    }
}

